/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.io.ZipInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ArchiveEntrySource<T extends ZipInput>
extends InputSource {
    private final T zipInput;
    private final ArchiveEntry archiveEntry;

    public ArchiveEntrySource(T zipInput, ArchiveEntry archiveEntry) {
        super(archiveEntry.getSanitizedName());
        this.zipInput = zipInput;
        this.archiveEntry = archiveEntry;
        this.setMethod(archiveEntry.getMethod());
    }

    public T getZipSource() {
        return this.zipInput;
    }

    public ArchiveEntry getArchiveEntry() {
        return this.archiveEntry;
    }

    @Override
    public InputStream openStream() throws IOException {
        ArchiveEntry archiveEntry = this.getArchiveEntry();
        LocalFileHeader lfh = archiveEntry.getLocalFileHeader();
        InputStream inputStream = this.getZipSource().getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
        if (lfh.getSize() == lfh.getCompressedSize()) {
            return inputStream;
        }
        return new InflaterInputStream(inputStream, new Inflater(true), 512);
    }

    @Override
    public long getLength() throws IOException {
        return this.getArchiveEntry().getDataSize();
    }

    @Override
    public long getCrc() throws IOException {
        return this.getArchiveEntry().getCrc();
    }
}

