/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.ArchiveException;
import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.Zip64Locator;
import com.reandroid.archive.block.Zip64Record;
import com.reandroid.archive.block.ZipHeader;
import com.reandroid.archive.io.ZipInput;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.InputStream;

public class EndRecord
extends ZipHeader {
    private Zip64Locator zip64Locator;
    private Zip64Record zip64Record;
    private static final int OFFSET_numberOfDisk = 4;
    private static final int OFFSET_centralDirectoryStartDisk = 6;
    private static final int OFFSET_numberOfDirectories = 8;
    private static final int OFFSET_totalNumberOfDirectories = 10;
    private static final int OFFSET_lengthOfCentralDirectory = 12;
    private static final int OFFSET_offsetOfCentralDirectory = 16;
    private static final int OFFSET_lastShort = 20;
    public static final int MIN_LENGTH = 22;
    public static final int MAX_LENGTH = 65557;

    public EndRecord() {
        super(22, ZipSignature.END_RECORD);
    }

    public int getTotalBytesCount() {
        int count = this.countBytes();
        ZipHeader zipHeader = this.getZip64Locator();
        if (zipHeader != null) {
            count += this.zip64Locator.countBytes();
        }
        if ((zipHeader = this.getZip64Record()) != null) {
            count += this.zip64Locator.countBytes();
        }
        return count;
    }

    private boolean isZip64Value() {
        return this.getInteger(16) == -1;
    }

    public Zip64Locator getZip64Locator() {
        return this.zip64Locator;
    }

    public void setZip64Locator(Zip64Locator zip64Locator) {
        this.zip64Locator = zip64Locator;
    }

    public Zip64Record getZip64Record() {
        return this.zip64Record;
    }

    public void setZip64Record(Zip64Record zip64Record) {
        this.zip64Record = zip64Record;
    }

    public void findEndRecord(ZipInput zipInput) throws IOException {
        byte[] footer = zipInput.getFooter(65581);
        this.findEndRecord(footer);
        Zip64Locator zip64Locator = this.getZip64Locator();
        if (zip64Locator == null) {
            return;
        }
        Zip64Record zip64Record = new Zip64Record();
        InputStream inputStream = zipInput.getInputStream(zip64Locator.getOffsetZip64Record(), 56L);
        zip64Record.readBytes(inputStream);
        if (!zip64Record.isValidSignature()) {
            throw new IOException("Invalid " + (Object)((Object)ZipSignature.ZIP64_RECORD) + ": " + HexUtil.toHex8(zip64Record.getSignatureValue()));
        }
        this.setZip64Record(zip64Record);
    }

    public void findEndRecord(byte[] footer) throws IOException {
        int length = footer.length;
        int minLength = 22;
        int start = length - minLength;
        int offset = 0;
        for (offset = start; offset >= 0; --offset) {
            this.putBytes(footer, offset, 0, minLength);
            if (this.isValidSignature()) break;
        }
        if (!this.isValidSignature()) {
            throw new ArchiveException("Failed to find end record");
        }
        if (!this.isZip64Value()) {
            return;
        }
        Zip64Locator zip64Locator = new Zip64Locator();
        minLength = 20;
        offset -= minLength;
        while (offset >= 0) {
            zip64Locator.putBytes(footer, offset, 0, minLength);
            if (zip64Locator.isValidSignature()) break;
            --offset;
        }
        if (!zip64Locator.isValidSignature()) {
            throw new ArchiveException("Failed to find zip64 locator");
        }
        this.setZip64Locator(zip64Locator);
    }

    public int getNumberOfDisk() {
        return this.getShortUnsigned(4);
    }

    public void setNumberOfDisk(int value) {
        this.putShort(4, value);
    }

    public int getCentralDirectoryStartDisk() {
        return this.getShortUnsigned(6);
    }

    public void setCentralDirectoryStartDisk(int value) {
        this.putShort(6, value);
    }

    public int getNumberOfDirectories() {
        return this.getShortUnsigned(8);
    }

    public void setNumberOfDirectories(int value) {
        this.putShort(8, value);
        Zip64Record zip64Record = this.getZip64Record();
        if (zip64Record != null) {
            zip64Record.setNumberOfCDRecords(value);
        }
    }

    public int getTotalNumberOfDirectories() {
        return this.getShortUnsigned(10);
    }

    public void setTotalNumberOfDirectories(int value) {
        this.putShort(10, value);
        Zip64Record zip64Record = this.getZip64Record();
        if (zip64Record != null) {
            zip64Record.setTotalCDRecords(value);
        }
    }

    public long getLengthOfCentralDirectory() {
        return this.getIntegerUnsigned(12);
    }

    public void setLengthOfCentralDirectory(long value) {
        this.putInteger(12, value);
        Zip64Record zip64Record = this.getZip64Record();
        if (zip64Record != null) {
            zip64Record.setSizeOfCD(value);
        }
    }

    public long getOffsetOfCentralDirectory() {
        Zip64Record zip64Record = this.getZip64Record();
        if (zip64Record != null) {
            return zip64Record.getOffsetOfCentralDirectory();
        }
        return this.getIntegerUnsigned(16);
    }

    public void setOffsetOfCentralDirectory(long value) {
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            this.putInteger(16, value);
            this.zip64Locator = null;
            this.zip64Record = null;
        } else {
            Zip64Record zip64Record = this.zip64Record;
            if (zip64Record == null) {
                this.zip64Record = zip64Record = Zip64Record.newZip64Record();
            }
            this.putInteger(16, -1);
            zip64Record.setOffsetOfCentralDirectory(value);
            Zip64Locator zip64Locator = this.zip64Locator;
            if (zip64Locator == null) {
                this.zip64Locator = zip64Locator = Zip64Locator.newZip64Locator();
            }
        }
    }

    public int getLastShort() {
        return this.getShortUnsigned(20);
    }

    public void getLastShort(int value) {
        this.putShort(20, value);
    }

    public String toString() {
        if (this.countBytes() < this.getMinByteLength()) {
            return "Invalid";
        }
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getSignature());
        if (this.isZip64Value()) {
            builder.append(", ZIP64");
        }
        builder.append(", disks=").append(this.getNumberOfDisk());
        builder.append(", start disk=").append(this.getCentralDirectoryStartDisk());
        builder.append(", dirs=").append(this.getNumberOfDirectories());
        builder.append(", total dirs=").append(this.getTotalNumberOfDirectories());
        builder.append(", length=").append(this.getLengthOfCentralDirectory());
        builder.append(", offset=").append(this.getOffsetOfCentralDirectory());
        builder.append(", last=").append(HexUtil.toHex8(this.getLastShort()));
        return builder.toString();
    }
}

