/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.smali;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModuleEncoder;
import com.reandroid.apk.DexEncoder;
import com.reandroid.apkeditor.smali.SmaliUtil;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.utils.StringsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;

public class SmaliCompiler
implements DexEncoder {
    private APKLogger apkLogger;
    private final boolean noCache;

    public SmaliCompiler(boolean noCache) {
        this.noCache = noCache;
    }

    @Override
    public List<InputSource> buildDexFiles(ApkModuleEncoder apkModuleEncoder, File mainDir) throws IOException {
        File smaliDir = new File(mainDir, "smali");
        if (!smaliDir.isDirectory()) {
            return null;
        }
        ArrayList<InputSource> results = new ArrayList<InputSource>();
        List<File> classesDirList = this.listClassesDirectories(smaliDir);
        int i = 0;
        int size = classesDirList.size();
        for (File classesDir : classesDirList) {
            String progress = "(" + StringsUtil.formatNumber(++i, size) + "/" + size + ") ";
            InputSource inputSource = this.build(progress, classesDir);
            results.add(inputSource);
        }
        return results;
    }

    private InputSource build(String progress, File classesDir) throws IOException {
        File dexCacheFile = this.toDexCache(classesDir);
        if (this.isModified(classesDir, dexCacheFile)) {
            return this.build(progress, classesDir, dexCacheFile);
        }
        this.logMessage(progress + "Cached: " + dexCacheFile.getName());
        return new FileInputSource(dexCacheFile, dexCacheFile.getName());
    }

    private InputSource build(String progress, File classesDir, File dexCacheFile) throws IOException {
        boolean success;
        this.logMessage(progress + "Smali: " + dexCacheFile.getName());
        SmaliOptions smaliOptions = new SmaliOptions();
        File dir = dexCacheFile.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        smaliOptions.outputDexFile = dexCacheFile.getAbsolutePath();
        if (smaliOptions.jobs <= 0) {
            smaliOptions.jobs = 1;
        }
        if (!(success = Smali.assemble(smaliOptions, classesDir.getAbsolutePath()))) {
            throw new IOException("Failed to build smali, check the logs");
        }
        return new FileInputSource(dexCacheFile, dexCacheFile.getName());
    }

    private boolean isModified(File classesDir, File dexCacheFile) {
        if (this.noCache || !dexCacheFile.isFile()) {
            return true;
        }
        long dexMod = dexCacheFile.lastModified();
        return this.isModified(classesDir, dexMod);
    }

    private boolean isModified(File dir, long dexMod) {
        if (dir.lastModified() > dexMod) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!this.isModified(file, dexMod)) continue;
            return true;
        }
        return false;
    }

    private File toDexCache(File classesDir) {
        File mainDir = classesDir.getParentFile().getParentFile();
        File dir = new File(mainDir, ".cache");
        return new File(dir, SmaliUtil.getDexFileName(SmaliUtil.getDexNumber(classesDir.getName())));
    }

    private List<File> listClassesDirectories(File smaliDir) {
        ArrayList<File> results = new ArrayList<File>();
        if (!smaliDir.isDirectory()) {
            return results;
        }
        File[] files = smaliDir.listFiles();
        if (files == null) {
            return results;
        }
        for (File file : files) {
            if (!SmaliUtil.isClassesDir(file)) {
                this.logMessage("WARN: Ignore: " + file);
                continue;
            }
            results.add(file);
        }
        SmaliUtil.sortDexFiles(results);
        return results;
    }

    public void setApkLogger(APKLogger apkLogger) {
        this.apkLogger = apkLogger;
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.apkLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }
}

