/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.merge;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class MergerOptions
extends Options {
    public boolean validateResDir;
    public boolean cleanMeta;
    public String resDirName;

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseOutput(args);
        this.parseResDirName(args);
        this.parseValidateResDir(args);
        this.parseCleanMeta(args);
        super.parse(args);
    }

    private void parseValidateResDir(String[] args) throws ARGException {
        this.validateResDir = this.containsArg("-vrd", true, args);
    }

    private void parseCleanMeta(String[] args) throws ARGException {
        this.cleanMeta = this.containsArg("-clean-meta", true, args);
    }

    private void parseResDirName(String[] args) throws ARGException {
        this.resDirName = this.parseArgValue("-res-dir", true, args);
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile("-o", args);
        if (file == null) {
            file = this.getOutputApkFromInput(this.inputFile);
        }
        this.outputFile = file;
    }

    private File getOutputApkFromInput(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_merged.apk";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input directory");
        }
        if (!file.exists()) {
            throw new ARGException("No such file/directory: " + file);
        }
        this.inputFile = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   Input: ").append(this.inputFile);
        builder.append("\n Output: ").append(this.outputFile);
        if (this.resDirName != null) {
            builder.append("\nres dir: ").append(this.resDirName);
        }
        if (this.validateResDir) {
            builder.append("\n Validate res dir name: true");
        }
        if (this.force) {
            builder.append("\n Force: true");
        }
        if (this.cleanMeta) {
            builder.append("\n Keep meta: true");
        }
        builder.append("\n ---------------------------- ");
        return builder.toString();
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Merges split apk files from directory or compressed apk files like XAPK, APKM, APKS ...");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}, {"-res-dir", "sets resource files root dir name\n(eg. for obfuscation to move files from 'res/*' to 'r/*' or vice versa)"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{"-f", "force delete output path"}, {"-clean-meta", "cleans META-INF directory along with signature block"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("m").append(" ").append("-i").append(" path/to/input");
        builder.append(" ").append("-o").append(" path/to/out.apk");
        return builder.toString();
    }
}

