/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.compile;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleJsonEncoder;
import com.reandroid.apk.ApkModuleRawEncoder;
import com.reandroid.apk.ApkModuleXmlEncoder;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.compile.BuildOptions;
import com.reandroid.apkeditor.smali.SmaliCompiler;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.writer.ApkFileWriter;
import com.reandroid.arsc.coder.xml.XmlCoder;
import com.reandroid.commons.command.ARGException;
import java.io.File;
import java.io.IOException;

public class Builder
extends BaseCommand<BuildOptions> {
    public static final String ARG_SHORT = "b";
    public static final String ARG_LONG = "build";
    public static final String DESCRIPTION = "Builds android binary from json/xml";

    public Builder(BuildOptions options) {
        super(options, "[BUILD] ");
    }

    @Override
    public void run() throws IOException {
        BuildOptions options = (BuildOptions)this.getOptions();
        if (options.signaturesDirectory != null && options.inputFile.isFile()) {
            this.restoreSignatures();
            return;
        }
        if (options.isRaw) {
            this.buildRaw();
        } else if (options.isXml) {
            this.buildXml();
        } else {
            this.buildJson();
        }
    }

    private void restoreSignatures() throws IOException {
        this.logMessage("Restoring signatures ...");
        BuildOptions options = (BuildOptions)this.getOptions();
        ArchiveFile archive = new ArchiveFile(options.inputFile);
        ApkFileWriter apkWriter = new ApkFileWriter(options.outputFile, archive.getInputSources());
        apkWriter.setAPKLogger(this);
        ApkSignatureBlock apkSignatureBlock = new ApkSignatureBlock();
        apkSignatureBlock.scanSplitFiles(options.signaturesDirectory);
        apkWriter.setApkSignatureBlock(apkSignatureBlock);
        this.logMessage("Writing apk...");
        apkWriter.write();
        this.logMessage("Saved to: " + options.outputFile);
        apkWriter.close();
    }

    public void buildJson() throws IOException {
        this.logMessage("Scanning JSON directory ...");
        ApkModuleJsonEncoder encoder = new ApkModuleJsonEncoder();
        encoder.setApkLogger(this);
        BuildOptions options = (BuildOptions)this.getOptions();
        SmaliCompiler smaliCompiler = new SmaliCompiler(options.noCache);
        smaliCompiler.setApkLogger(this);
        encoder.setDexEncoder(smaliCompiler);
        encoder.scanDirectory(options.inputFile);
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this);
        if (options.resDirName != null) {
            this.logMessage("Renaming resources root dir: " + options.resDirName);
            loadedModule.setResourcesRootDir(options.resDirName);
        }
        if (options.validateResDir) {
            this.logMessage("Validating resources dir ...");
            loadedModule.validateResourcesDir();
        }
        this.logMessage("Writing apk...");
        loadedModule.getZipEntryMap().autoSortApkFiles();
        loadedModule.writeApk(options.outputFile, null);
        loadedModule.close();
        this.logMessage("Saved to: " + options.outputFile);
    }

    public void buildXml() throws IOException {
        this.logMessage("Scanning XML directory ...");
        XmlCoder.getInstance().setLogger(this);
        ApkModuleXmlEncoder encoder = new ApkModuleXmlEncoder();
        encoder.setApkLogger(this);
        BuildOptions options = (BuildOptions)this.getOptions();
        SmaliCompiler smaliCompiler = new SmaliCompiler(options.noCache);
        smaliCompiler.setApkLogger(this);
        encoder.setDexEncoder(smaliCompiler);
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this);
        loadedModule.setPreferredFramework(options.frameworkVersion);
        if (options.frameworks != null) {
            for (File file : options.frameworks) {
                loadedModule.addExternalFramework(file);
            }
        }
        encoder.scanDirectory(options.inputFile);
        loadedModule = encoder.getApkModule();
        this.logMessage("Writing apk...");
        loadedModule.writeApk(options.outputFile, null);
        loadedModule.close();
        this.logMessage("Saved to: " + options.outputFile);
    }

    public void buildRaw() throws IOException {
        this.logMessage("Scanning Raw directory ...");
        ApkModuleRawEncoder encoder = new ApkModuleRawEncoder();
        encoder.setApkLogger(this);
        BuildOptions options = (BuildOptions)this.getOptions();
        SmaliCompiler smaliCompiler = new SmaliCompiler(options.noCache);
        smaliCompiler.setApkLogger(this);
        encoder.setDexEncoder(smaliCompiler);
        ApkModule loadedModule = encoder.getApkModule();
        loadedModule.setAPKLogger(this);
        loadedModule.setPreferredFramework(options.frameworkVersion);
        if (options.frameworks != null) {
            for (File file : options.frameworks) {
                loadedModule.addExternalFramework(file);
            }
        }
        encoder.scanDirectory(options.inputFile);
        loadedModule = encoder.getApkModule();
        this.logMessage("Writing apk...");
        loadedModule.writeApk(options.outputFile, null);
        loadedModule.close();
        this.logMessage("Saved to: " + options.outputFile);
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(BuildOptions.getHelp());
        }
        BuildOptions option = new BuildOptions();
        option.parse(args);
        if (Builder.isRawInDir(option.inputFile)) {
            option.isRaw = true;
        } else if (Builder.isJsonInDir(option.inputFile)) {
            option.inputFile = Builder.getJsonInDir(option.inputFile);
        } else if (Builder.isXmlInDir(option.inputFile)) {
            option.isXml = true;
        } else if (option.signaturesDirectory == null) {
            throw new ARGException("Not xml/json directory: " + option.inputFile);
        }
        File outDir = option.outputFile;
        Util.deleteEmptyDirectories(outDir);
        Builder builder = new Builder(option);
        builder.logMessage("Building ...\n" + option.toString());
        if (outDir.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outDir);
            }
            builder.logMessage("Deleting: " + outDir);
            Util.deleteDir(outDir);
        }
        builder.run();
    }

    private static boolean isRawInDir(File dir) {
        File file = new File(dir, "AndroidManifest.xml.bin");
        if (!file.isFile()) {
            file = new File(dir, "resources.arsc");
        }
        return file.isFile();
    }

    private static boolean isXmlInDir(File dir) {
        File manifest = new File(dir, "AndroidManifest.xml");
        return manifest.isFile();
    }

    private static boolean isJsonInDir(File dir) {
        if (Builder.isModuleDir(dir)) {
            return true;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (File file : files) {
            if (!Builder.isModuleDir(file)) continue;
            return true;
        }
        return false;
    }

    private static File getJsonInDir(File dir) throws ARGException {
        if (Builder.isModuleDir(dir)) {
            return dir;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new ARGException("Empty directory: " + dir);
        }
        for (File file : files) {
            if (!Builder.isModuleDir(file)) continue;
            return file;
        }
        throw new ARGException("Invalid directory: " + dir + ", missing file \"uncompressed-files.json\"");
    }

    private static boolean isModuleDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File manifest = new File(dir, "AndroidManifest.xml.json");
        if (manifest.isFile()) {
            return true;
        }
        File file = new File(dir, "AndroidManifest.xml.json");
        return file.isFile();
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

