/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.CrcOutputStream;
import com.reandroid.apk.TableBlockJsonBuilder;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SplitJsonTableInputSource
extends InputSource {
    private final File resourcesDirectory;
    private TableBlock mCache;
    private APKLogger apkLogger;

    public SplitJsonTableInputSource(File resourcesDirectory) {
        super("resources.arsc");
        this.resourcesDirectory = resourcesDirectory;
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return this.getTableBlock().writeBytes(outputStream);
    }

    @Override
    public InputStream openStream() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return new ByteArrayInputStream(tableBlock.getBytes());
    }

    @Override
    public long getLength() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return tableBlock.countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        CrcOutputStream outputStream = new CrcOutputStream();
        this.write(outputStream);
        return outputStream.getCrcValue();
    }

    public TableBlock getTableBlock() throws IOException {
        TableBlock tableBlock;
        if (this.mCache != null) {
            return this.mCache;
        }
        TableBlockJsonBuilder builder = new TableBlockJsonBuilder();
        this.mCache = tableBlock = builder.scanDirectory(this.resourcesDirectory);
        return tableBlock;
    }

    public void setApkLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }
}

