/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.AndroidFrameworks;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.DexFileInputSource;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.SingleJsonTableInputSource;
import com.reandroid.apk.SplitJsonTableInputSource;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.archive.ArchiveBytes;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.WriteProgress;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.io.ArchiveFileEntrySource;
import com.reandroid.archive.writer.ApkByteWriter;
import com.reandroid.archive.writer.ApkFileWriter;
import com.reandroid.archive.writer.ApkStreamWriter;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.array.PackageArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.model.FrameworkTable;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.EmptyList;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;

public class ApkModule
implements ApkFile,
Closeable {
    private String moduleName;
    private final ZipEntryMap zipEntryMap;
    private boolean loadDefaultFramework = true;
    private boolean mDisableLoadFramework = false;
    private TableBlock mTableBlock;
    private InputSource mTableOriginalSource;
    private AndroidManifestBlock mManifestBlock;
    private InputSource mManifestOriginalSource;
    private final UncompressedFiles mUncompressedFiles;
    private APKLogger apkLogger;
    private ApkFile.ApkType mApkType;
    private ApkSignatureBlock apkSignatureBlock;
    private Integer preferredFramework;
    private Closeable mCloseable;
    private final List<TableBlock> mExternalFrameworks;

    public ApkModule(String moduleName, ZipEntryMap zipEntryMap) {
        this.moduleName = moduleName;
        this.zipEntryMap = zipEntryMap;
        this.mUncompressedFiles = new UncompressedFiles();
        this.mUncompressedFiles.addPath(zipEntryMap);
        this.mExternalFrameworks = new ArrayList<TableBlock>();
    }

    public ApkModule(ZipEntryMap zipEntryMap) {
        this("base", zipEntryMap);
    }

    public ApkModule() {
        this("base", new ZipEntryMap());
    }

    public void addExternalFramework(File frameworkFile) throws IOException {
        if (frameworkFile == null) {
            return;
        }
        this.logMessage("Loading external framework: " + frameworkFile);
        FrameworkApk framework = FrameworkApk.loadTableBlock(frameworkFile);
        framework.setAPKLogger(this.getApkLogger());
        this.addExternalFramework(framework);
    }

    public void addExternalFramework(ApkModule apkModule) {
        if (apkModule == null || apkModule == this || !apkModule.hasTableBlock()) {
            return;
        }
        this.addExternalFramework(apkModule.getTableBlock());
    }

    public void addExternalFramework(TableBlock tableBlock) {
        if (tableBlock == null || tableBlock.getApkFile() == this || this.mExternalFrameworks.contains(tableBlock)) {
            return;
        }
        this.mExternalFrameworks.add(tableBlock);
        this.updateExternalFramework();
    }

    public String refreshTable() {
        TableBlock tableBlock = this.mTableBlock;
        if (tableBlock != null) {
            return tableBlock.refreshFull();
        }
        return null;
    }

    public String refreshManifest() {
        AndroidManifestBlock manifestBlock = this.mManifestBlock;
        if (manifestBlock != null) {
            return manifestBlock.refreshFull();
        }
        return null;
    }

    public void validateResourceNames() {
        if (!this.hasTableBlock()) {
            return;
        }
        this.logMessage("Validating resource names ...");
        TableBlock tableBlock = this.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.validateResourceNames(packageBlock);
        }
    }

    public void validateResourceNames(PackageBlock packageBlock) {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.load(packageBlock);
        if (!packageIdentifier.hasDuplicateResources()) {
            return;
        }
        this.logMessage("Renaming duplicate resources ... ");
        packageIdentifier.ensureUniqueResourceNames();
        packageIdentifier.setResourceNamesToPackage(packageBlock);
    }

    public ApkSignatureBlock getApkSignatureBlock() {
        return this.apkSignatureBlock;
    }

    public void setApkSignatureBlock(ApkSignatureBlock apkSignatureBlock) {
        this.apkSignatureBlock = apkSignatureBlock;
    }

    public boolean hasSignatureBlock() {
        return this.getApkSignatureBlock() != null;
    }

    public void dumpSignatureInfoFiles(File directory) throws IOException {
        ApkSignatureBlock apkSignatureBlock = this.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            throw new IOException("Don't have signature block");
        }
        apkSignatureBlock.writeSplitRawToDirectory(directory);
    }

    public void dumpSignatureBlock(File file) throws IOException {
        ApkSignatureBlock apkSignatureBlock = this.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            throw new IOException("Don't have signature block");
        }
        apkSignatureBlock.writeRaw(file);
    }

    public void scanSignatureInfoFiles(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IOException("No such directory: " + directory);
        }
        ApkSignatureBlock apkSignatureBlock = this.apkSignatureBlock;
        if (apkSignatureBlock == null) {
            apkSignatureBlock = new ApkSignatureBlock();
        }
        apkSignatureBlock.scanSplitFiles(directory);
        this.setApkSignatureBlock(apkSignatureBlock);
    }

    public void loadSignatureBlock(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("No such file: " + file);
        }
        ApkSignatureBlock apkSignatureBlock = this.apkSignatureBlock;
        if (apkSignatureBlock == null) {
            apkSignatureBlock = new ApkSignatureBlock();
        }
        apkSignatureBlock.read(file);
        this.setApkSignatureBlock(apkSignatureBlock);
    }

    public String getSplit() {
        if (!this.hasAndroidManifestBlock()) {
            return null;
        }
        return this.getAndroidManifestBlock().getSplit();
    }

    public List<TableBlock> getLoadedFrameworks() {
        ArrayList<TableBlock> results = new ArrayList<TableBlock>();
        if (!this.hasTableBlock()) {
            return results;
        }
        TableBlock tableBlock = this.getTableBlock(false);
        results.addAll(tableBlock.getFrameWorks());
        return results;
    }

    public boolean isFrameworkVersionLoaded(Integer version) {
        if (version == null) {
            return false;
        }
        for (TableBlock tableBlock : this.getLoadedFrameworks()) {
            FrameworkTable frame;
            if (!(tableBlock instanceof FrameworkTable) || !version.equals((frame = (FrameworkTable)tableBlock).getVersionCode())) continue;
            return true;
        }
        return false;
    }

    public FrameworkApk getLoadedFramework(Integer version, boolean onlyAndroid) {
        for (TableBlock tableBlock : this.getLoadedFrameworks()) {
            if (!(tableBlock instanceof FrameworkTable)) continue;
            FrameworkTable frame = (FrameworkTable)tableBlock;
            if (onlyAndroid && !this.isAndroid(frame) || version != null && !version.equals(frame.getVersionCode())) continue;
            return (FrameworkApk)frame.getApkFile();
        }
        return null;
    }

    public FrameworkApk initializeAndroidFramework(Integer version) throws IOException {
        TableBlock tableBlock = this.getTableBlock(false);
        return this.initializeAndroidFramework(tableBlock, version);
    }

    public FrameworkApk initializeAndroidFramework(TableBlock tableBlock, Integer version) throws IOException {
        FrameworkApk frameworkApk;
        if (this.mDisableLoadFramework || tableBlock == null || this.isAndroid(tableBlock)) {
            return null;
        }
        FrameworkApk exist = this.getLoadedFramework(version, true);
        if (exist != null) {
            return exist;
        }
        this.logMessage("Initializing android framework ...");
        if (version == null) {
            this.logMessage("Can not read framework version, loading latest");
            frameworkApk = AndroidFrameworks.getLatest();
        } else {
            this.logMessage("Loading android framework for version: " + version);
            frameworkApk = AndroidFrameworks.getBestMatch(version);
        }
        FrameworkTable frameworkTable = frameworkApk.getTableBlock();
        tableBlock.addFramework(frameworkTable);
        this.logMessage("Initialized framework: " + frameworkApk.getName() + " (" + frameworkApk.getVersionName() + ")");
        return frameworkApk;
    }

    public FrameworkApk initializeAndroidFramework(XMLDocument xmlDocument) throws IOException {
        if (this.preferredFramework != null) {
            return this.initializeAndroidFramework(this.preferredFramework);
        }
        if (this.isAndroidCoreApp(xmlDocument)) {
            this.logMessage("Looks framework itself, skip loading frameworks");
            return null;
        }
        Integer version = this.readVersionCode(xmlDocument);
        return this.initializeAndroidFramework(version);
    }

    private boolean isAndroid(TableBlock tableBlock) {
        if (tableBlock instanceof FrameworkTable) {
            FrameworkTable frameworkTable = (FrameworkTable)tableBlock;
            return frameworkTable.isAndroid();
        }
        return false;
    }

    private boolean isAndroidCoreApp(XMLDocument manifestDocument) {
        XMLElement root = manifestDocument.getDocumentElement();
        if (root == null) {
            return false;
        }
        if (!"android".equals(root.getAttributeValue("package"))) {
            return false;
        }
        String coreApp = root.getAttributeValue("coreApp");
        return "true".equals(coreApp);
    }

    private Integer readVersionCode(XMLDocument xmlDocument) {
        if (xmlDocument == null) {
            return null;
        }
        XMLElement manifestRoot = xmlDocument.getDocumentElement();
        if (manifestRoot == null) {
            this.logMessage("WARN: Manifest root not found");
            return null;
        }
        String versionString = manifestRoot.getAttributeValue("android:compileSdkVersion");
        Integer version = null;
        if (versionString != null) {
            version = this.safeParseInteger(versionString);
        }
        if (version == null && (versionString = manifestRoot.getAttributeValue("platformBuildVersionCode")) != null) {
            version = this.safeParseInteger(versionString);
        }
        Integer target = null;
        Iterator<XMLElement> iterator = manifestRoot.getElements("uses-sdk");
        while (iterator.hasNext()) {
            XMLElement element = iterator.next();
            versionString = element.getAttributeValue("android:targetSdkVersion");
            if (versionString == null) continue;
            target = this.safeParseInteger(versionString);
        }
        if (version == null) {
            version = target;
        } else if (target != null && target > version) {
            version = target;
        }
        return version;
    }

    private Integer safeParseInteger(String versionString) {
        try {
            return Integer.parseInt(versionString);
        }
        catch (NumberFormatException exception) {
            this.logMessage("NumberFormatException on manifest version reading: '" + versionString + "': " + exception.getMessage());
            return null;
        }
    }

    public void setPreferredFramework(Integer version) throws IOException {
        if (version != null && version.equals(this.preferredFramework)) {
            return;
        }
        this.preferredFramework = version;
        if (version == null || this.mTableBlock == null) {
            return;
        }
        if (this.isFrameworkVersionLoaded(version)) {
            return;
        }
        this.logMessage("Initializing preferred framework: " + version);
        this.mTableBlock.clearFrameworks();
        FrameworkApk frameworkApk = AndroidFrameworks.getBestMatch(version);
        AndroidFrameworks.setCurrent(frameworkApk);
        this.mTableBlock.addFramework(frameworkApk.getTableBlock());
        this.logMessage("Initialized framework: " + frameworkApk.getVersionCode());
    }

    public Integer getAndroidFrameworkVersion() {
        if (this.preferredFramework != null) {
            return this.preferredFramework;
        }
        if (!this.hasAndroidManifestBlock()) {
            return null;
        }
        AndroidManifestBlock manifestBlock = this.getAndroidManifestBlock();
        Integer version = manifestBlock.getCompileSdkVersion();
        if (version == null) {
            version = manifestBlock.getPlatformBuildVersionCode();
        }
        Integer target = manifestBlock.getTargetSdkVersion();
        if (version == null) {
            version = target;
        } else if (target != null && target > version) {
            version = target;
        }
        return version;
    }

    public void removeResFilesWithEntry(int resourceId) {
        this.removeResFilesWithEntry(resourceId, null, true);
    }

    public void removeResFilesWithEntry(int resourceId, ResConfig resConfig, boolean trimEntryArray) {
        List<Entry> removedList = this.removeResFiles(resourceId, resConfig);
        SpecTypePair specTypePair = null;
        for (Entry entry : removedList) {
            if (entry == null || entry.isNull()) continue;
            if (trimEntryArray && specTypePair == null) {
                specTypePair = entry.getTypeBlock().getParentSpecTypePair();
            }
            entry.setNull(true);
        }
        if (specTypePair != null) {
            specTypePair.removeNullEntries(resourceId);
        }
    }

    public List<Entry> removeResFiles(int resourceId) {
        return this.removeResFiles(resourceId, null);
    }

    public List<Entry> removeResFiles(int resourceId, ResConfig resConfig) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        if (resourceId == 0 && resConfig == null) {
            return results;
        }
        List<ResFile> resFileList = this.listResFiles(resourceId, resConfig);
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        for (ResFile resFile : resFileList) {
            results.addAll(resFile.getEntryList());
            String path = resFile.getFilePath();
            zipEntryMap.remove(path);
        }
        return results;
    }

    public XMLDocument decodeXMLFile(String path) throws IOException {
        PackageBlock packageBlock;
        ResXmlDocument resXmlDocument = this.loadResXmlDocument(path);
        AndroidManifestBlock manifestBlock = this.getAndroidManifestBlock();
        int pkgId = manifestBlock.guessCurrentPackageId();
        if (pkgId != 0 && this.hasTableBlock() && (packageBlock = this.getTableBlock().pickOne(pkgId)) != null) {
            resXmlDocument.setPackageBlock(packageBlock);
        }
        return resXmlDocument.decodeToXml();
    }

    public List<DexFileInputSource> listDexFiles() {
        ArrayList<DexFileInputSource> results = new ArrayList<DexFileInputSource>();
        for (InputSource source : this.getInputSources()) {
            if (!DexFileInputSource.isDexName(source.getAlias())) continue;
            DexFileInputSource inputSource = source instanceof DexFileInputSource ? (DexFileInputSource)source : new DexFileInputSource(source.getAlias(), source);
            results.add(inputSource);
        }
        DexFileInputSource.sort(results);
        return results;
    }

    public boolean isBaseModule() {
        if (!this.hasAndroidManifestBlock()) {
            return false;
        }
        try {
            AndroidManifestBlock manifestBlock = this.getAndroidManifestBlock();
            return manifestBlock.getMainActivity() != null;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException();
        }
        this.moduleName = moduleName;
    }

    public void writeApk(File file) throws IOException {
        this.writeApk(file, null);
    }

    public void writeApk(File file, WriteProgress progress) throws IOException {
        ApkFileWriter writer = this.createApkFileWriter(file);
        writer.setWriteProgress(progress);
        writer.write();
    }

    public byte[] writeApkBytes() throws IOException {
        ApkByteWriter writer = this.createApkByteWriter();
        writer.write();
        return writer.toByteArray();
    }

    public void writeApk(OutputStream outputStream) throws IOException {
        this.createApkStreamWriter(outputStream).write();
    }

    public ApkFileWriter createApkFileWriter(File file) throws IOException {
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        UncompressedFiles uf = this.getUncompressedFiles();
        uf.apply(zipEntryMap);
        ApkFileWriter writer = new ApkFileWriter(file, zipEntryMap.toArray(true));
        writer.setAPKLogger(this.getApkLogger());
        writer.setApkSignatureBlock(this.getApkSignatureBlock());
        return writer;
    }

    public ApkByteWriter createApkByteWriter() {
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        UncompressedFiles uf = this.getUncompressedFiles();
        uf.apply(zipEntryMap);
        ApkByteWriter writer = new ApkByteWriter(zipEntryMap.toArray(true));
        writer.setAPKLogger(this.getApkLogger());
        writer.setApkSignatureBlock(this.getApkSignatureBlock());
        return writer;
    }

    public ApkStreamWriter createApkStreamWriter(OutputStream outputStream) {
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        UncompressedFiles uf = this.getUncompressedFiles();
        uf.apply(zipEntryMap);
        ApkStreamWriter writer = new ApkStreamWriter(outputStream, zipEntryMap.toArray(true));
        writer.setAPKLogger(this.getApkLogger());
        writer.setApkSignatureBlock(this.getApkSignatureBlock());
        return writer;
    }

    public void uncompressNonXmlResFiles() {
        for (ResFile resFile : this.listResFiles()) {
            if (resFile.isBinaryXml()) continue;
            resFile.getInputSource().setMethod(0);
        }
    }

    public UncompressedFiles getUncompressedFiles() {
        return this.mUncompressedFiles;
    }

    public void removeDir(String dirName) {
        this.getZipEntryMap().removeDir(dirName);
    }

    public void validateResourcesDir() {
        List<ResFile> resFileList = this.listResFiles();
        HashSet<String> existPaths = new HashSet<String>();
        InputSource[] sourceList = this.getInputSources();
        for (InputSource inputSource : sourceList) {
            existPaths.add(inputSource.getAlias());
        }
        for (ResFile resFile : resFileList) {
            String path = resFile.getFilePath();
            String pathNew = resFile.validateTypeDirectoryName();
            if (pathNew == null || pathNew.equals(path) || existPaths.contains(pathNew)) continue;
            existPaths.remove(path);
            existPaths.add(pathNew);
            resFile.setFilePath(pathNew);
            if (resFile.getInputSource().getMethod() == 0) {
                this.getUncompressedFiles().replacePath(path, pathNew);
            }
            this.logVerbose("Dir validated: '" + path + "' -> '" + pathNew + "'");
        }
        TableStringPool stringPool = this.getTableBlock().getStringPool();
        stringPool.refreshUniqueIdMap();
        this.getTableBlock().refresh();
    }

    public void setResourcesRootDir(String dirName) {
        List<ResFile> resFileList = this.listResFiles();
        HashSet<String> existPaths = new HashSet<String>();
        InputSource[] sourceList = this.getInputSources();
        for (InputSource inputSource : sourceList) {
            existPaths.add(inputSource.getAlias());
        }
        for (ResFile resFile : resFileList) {
            String path = resFile.getFilePath();
            String pathNew = ApkUtil.replaceRootDir(path, dirName);
            if (existPaths.contains(pathNew)) continue;
            existPaths.remove(path);
            existPaths.add(pathNew);
            resFile.setFilePath(pathNew);
            if (resFile.getInputSource().getMethod() == 0) {
                this.getUncompressedFiles().replacePath(path, pathNew);
            }
            this.logVerbose("Root changed: '" + path + "' -> '" + pathNew + "'");
        }
        TableStringPool stringPool = this.getTableBlock().getStringPool();
        stringPool.refreshUniqueIdMap();
        this.getTableBlock().refresh();
    }

    public List<ResFile> listResFiles() {
        return this.listResFiles(0, null);
    }

    public List<ResFile> listResFiles(int resourceId, ResConfig resConfig) {
        ArrayList<ResFile> results = new ArrayList<ResFile>();
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock == null) {
            return results;
        }
        TableStringPool stringPool = tableBlock.getStringPool();
        for (InputSource inputSource : this.getInputSources()) {
            String name = inputSource.getAlias();
            StringGroup groupTableString = stringPool.get(name);
            if (groupTableString == null) continue;
            for (TableString tableString : groupTableString.listItems()) {
                List<Entry> entryList = this.filterResFileEntries(tableString, resourceId, resConfig);
                if (entryList.size() == 0) continue;
                ResFile resFile = new ResFile(inputSource, entryList);
                results.add(resFile);
            }
        }
        return results;
    }

    public List<Entry> listReferencedEntries(String path) {
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock == null) {
            return new ArrayList<Entry>();
        }
        TableStringPool stringPool = tableBlock.getStringPool();
        StringGroup stringGroup = stringPool.get(path);
        if (stringGroup == null) {
            return EmptyList.of();
        }
        TableString tableString = (TableString)stringPool.get(0);
        return tableString.listReferencedResValueEntries();
    }

    private List<Entry> filterResFileEntries(TableString tableString, final int resourceId, final ResConfig resConfig) {
        Iterator<Entry> itr = tableString.getEntries(new Predicate<Entry>(){

            @Override
            public boolean test(Entry item) {
                if (!item.isScalar() || !TypeBlock.canHaveResourceFile(item.getTypeName())) {
                    return false;
                }
                if (resourceId != 0 && resourceId != item.getResourceId()) {
                    return false;
                }
                return resConfig == null || resConfig.equals(item.getResConfig());
            }
        });
        return CollectionUtil.toList(itr);
    }

    public String getPackageName() {
        if (this.hasAndroidManifestBlock()) {
            return this.getAndroidManifestBlock().getPackageName();
        }
        if (!this.hasTableBlock()) {
            return null;
        }
        TableBlock tableBlock = this.getTableBlock();
        PackageArray pkgArray = tableBlock.getPackageArray();
        PackageBlock pkg = (PackageBlock)pkgArray.get(0);
        if (pkg == null) {
            return null;
        }
        return pkg.getName();
    }

    public void setPackageName(String name) {
        String old = this.getPackageName();
        if (this.hasAndroidManifestBlock()) {
            this.getAndroidManifestBlock().setPackageName(name);
        }
        if (!this.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = this.getTableBlock();
        PackageArray pkgArray = tableBlock.getPackageArray();
        for (PackageBlock pkg : pkgArray.listItems()) {
            if (pkgArray.getChildesCount() == 1) {
                pkg.setName(name);
                continue;
            }
            String pkgName = pkg.getName();
            if (!pkgName.startsWith(old)) continue;
            pkgName = pkgName.replace(old, name);
            pkg.setName(pkgName);
        }
    }

    public boolean hasAndroidManifestBlock() {
        return this.mManifestBlock != null || this.getZipEntryMap().getInputSource("AndroidManifest.xml") != null;
    }

    public boolean hasTableBlock() {
        return this.mTableBlock != null || this.getZipEntryMap().getInputSource("resources.arsc") != null;
    }

    public void destroy() {
        TableBlock tableBlock;
        this.getZipEntryMap().clear();
        AndroidManifestBlock manifestBlock = this.mManifestBlock;
        if (manifestBlock != null) {
            manifestBlock.destroy();
            this.mManifestBlock = null;
        }
        if ((tableBlock = this.mTableBlock) != null) {
            this.mExternalFrameworks.clear();
            tableBlock.destroy();
            this.mTableBlock = null;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setManifest(AndroidManifestBlock manifestBlock) {
        ZipEntryMap archive = this.getZipEntryMap();
        if (manifestBlock == null) {
            this.mManifestBlock = null;
            archive.remove("AndroidManifest.xml");
            return;
        }
        manifestBlock.setApkFile(this);
        BlockInputSource<AndroidManifestBlock> source = new BlockInputSource<AndroidManifestBlock>("AndroidManifest.xml", manifestBlock);
        source.setMethod(0);
        source.setSort(0);
        archive.add(source);
        this.mManifestBlock = manifestBlock;
    }

    public void setTableBlock(TableBlock tableBlock) {
        ZipEntryMap archive = this.getZipEntryMap();
        if (tableBlock == null) {
            this.mTableBlock = null;
            archive.remove("resources.arsc");
            return;
        }
        tableBlock.setApkFile(this);
        BlockInputSource<TableBlock> source = new BlockInputSource<TableBlock>("resources.arsc", tableBlock);
        archive.add(source);
        source.setMethod(0);
        source.setSort(1);
        this.getUncompressedFiles().addPath(source);
        this.mTableBlock = tableBlock;
        this.updateExternalFramework();
    }

    @Override
    public AndroidManifestBlock getAndroidManifestBlock() {
        if (this.mManifestBlock != null) {
            return this.mManifestBlock;
        }
        InputSource inputSource = this.getInputSource("AndroidManifest.xml");
        if (inputSource == null) {
            return null;
        }
        this.setManifestOriginalSource(inputSource);
        InputStream inputStream = null;
        try {
            inputStream = inputSource.openStream();
            AndroidManifestBlock manifestBlock = AndroidManifestBlock.load(inputStream);
            inputStream.close();
            BlockInputSource<AndroidManifestBlock> blockInputSource = new BlockInputSource<AndroidManifestBlock>(inputSource.getName(), manifestBlock);
            blockInputSource.setSort(inputSource.getSort());
            blockInputSource.setMethod(inputSource.getMethod());
            this.addInputSource(blockInputSource);
            manifestBlock.setApkFile(this);
            TableBlock tableBlock = this.mTableBlock;
            if (tableBlock != null) {
                int packageId = manifestBlock.guessCurrentPackageId();
                if (packageId != 0) {
                    manifestBlock.setPackageBlock(tableBlock.pickOne(packageId));
                } else {
                    manifestBlock.setPackageBlock(tableBlock.pickOne());
                }
            }
            this.mManifestBlock = manifestBlock;
            this.onManifestBlockLoaded(manifestBlock);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
        return this.mManifestBlock;
    }

    private void onManifestBlockLoaded(AndroidManifestBlock manifestBlock) {
        this.initializeApkType(manifestBlock);
    }

    public TableBlock getTableBlock(boolean initFramework) {
        if (this.mTableBlock == null) {
            if (!this.hasTableBlock()) {
                return null;
            }
            try {
                this.mTableBlock = this.loadTableBlock();
                if (initFramework && this.loadDefaultFramework) {
                    Integer version = this.getAndroidFrameworkVersion();
                    this.initializeAndroidFramework(this.mTableBlock, version);
                }
                this.updateExternalFramework();
            }
            catch (IOException exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        return this.mTableBlock;
    }

    private void updateExternalFramework() {
        TableBlock tableBlock = this.mTableBlock;
        if (tableBlock == null) {
            return;
        }
        for (TableBlock framework : this.mExternalFrameworks) {
            tableBlock.addFramework(framework);
        }
    }

    public void discardManifestChanges() {
        this.getZipEntryMap().add(this.getManifestOriginalSource());
    }

    public void keepManifestChanges() {
        this.mManifestOriginalSource = null;
    }

    public InputSource getManifestOriginalSource() {
        InputSource inputSource = this.mManifestOriginalSource;
        if (inputSource == null) {
            this.mManifestOriginalSource = inputSource = this.getInputSource("AndroidManifest.xml");
        }
        return inputSource;
    }

    private void setManifestOriginalSource(InputSource inputSource) {
        if (this.mManifestOriginalSource == null && !(inputSource instanceof BlockInputSource)) {
            this.mManifestOriginalSource = inputSource;
        }
    }

    public void discardTableBlockChanges() {
        this.getZipEntryMap().add(this.getTableOriginalSource());
    }

    public void keepTableBlockChanges() {
        this.mTableOriginalSource = null;
    }

    public InputSource getTableOriginalSource() {
        InputSource inputSource = this.mTableOriginalSource;
        if (inputSource == null) {
            this.mTableOriginalSource = inputSource = this.getInputSource("resources.arsc");
        }
        return inputSource;
    }

    private void setTableOriginalSource(InputSource inputSource) {
        if (this.mTableOriginalSource == null && !(inputSource instanceof BlockInputSource)) {
            this.mTableOriginalSource = inputSource;
        }
    }

    @Override
    public TableBlock getTableBlock() {
        if (this.mTableBlock != null) {
            return this.mTableBlock;
        }
        this.checkExternalFramework();
        this.checkSelfFramework();
        return this.getTableBlock(!this.mDisableLoadFramework);
    }

    @Override
    public TableBlock getLoadedTableBlock() {
        return this.mTableBlock;
    }

    private void checkExternalFramework() {
        if (this.mDisableLoadFramework || this.preferredFramework != null) {
            return;
        }
        if (this.mExternalFrameworks.size() == 0) {
            return;
        }
        this.mDisableLoadFramework = true;
    }

    private void checkSelfFramework() {
        if (this.mDisableLoadFramework || this.preferredFramework != null) {
            return;
        }
        AndroidManifestBlock manifestBlock = this.getAndroidManifestBlock();
        if (manifestBlock == null) {
            return;
        }
        if (manifestBlock.isCoreApp() == null || !"android".equals(manifestBlock.getPackageName())) {
            return;
        }
        if (manifestBlock.guessCurrentPackageId() != 1) {
            return;
        }
        this.logMessage("Looks like framework apk, skip loading framework");
        this.mDisableLoadFramework = true;
    }

    @Override
    public ResXmlDocument loadResXmlDocument(String path) throws IOException {
        InputSource inputSource = this.getInputSource(path);
        if (inputSource == null) {
            throw new FileNotFoundException("No such file in apk: " + path);
        }
        return this.loadResXmlDocument(inputSource);
    }

    public ResXmlDocument loadResXmlDocument(InputSource inputSource) throws IOException {
        ResXmlDocument resXmlDocument = new ResXmlDocument();
        resXmlDocument.setApkFile(this);
        resXmlDocument.readBytes(inputSource.openStream());
        TableBlock tableBlock = this.getTableBlock();
        if (tableBlock != null) {
            resXmlDocument.setPackageBlock(tableBlock.pickOne());
        }
        return resXmlDocument;
    }

    public ApkFile.ApkType getApkType() {
        if (this.mApkType != null) {
            return this.mApkType;
        }
        return this.initializeApkType(this.mManifestBlock);
    }

    public void setApkType(ApkFile.ApkType apkType) {
        this.mApkType = apkType;
    }

    private ApkFile.ApkType initializeApkType(AndroidManifestBlock manifestBlock) {
        if (this.mApkType != null) {
            return this.mApkType;
        }
        ApkFile.ApkType apkType = null;
        if (manifestBlock != null) {
            apkType = manifestBlock.guessApkType();
        }
        if (apkType != null) {
            this.mApkType = apkType;
        } else {
            apkType = ApkFile.ApkType.UNKNOWN;
        }
        return apkType;
    }

    public TableStringPool getVolatileTableStringPool() throws IOException {
        if (this.mTableBlock != null) {
            return this.mTableBlock.getStringPool();
        }
        InputSource inputSource = this.getInputSource("resources.arsc");
        if (inputSource == null) {
            throw new IOException("Module don't have: resources.arsc");
        }
        if (inputSource instanceof ArchiveFileEntrySource || inputSource instanceof FileInputSource) {
            InputStream inputStream = inputSource.openStream();
            TableStringPool stringPool = TableStringPool.readFromTable(inputStream);
            inputStream.close();
            return stringPool;
        }
        return this.getTableBlock().getStringPool();
    }

    TableBlock loadTableBlock() throws IOException {
        TableBlock tableBlock;
        InputSource inputSource = this.getInputSource("resources.arsc");
        if (inputSource == null) {
            throw new IOException("Entry not found: resources.arsc");
        }
        if (inputSource instanceof SplitJsonTableInputSource) {
            tableBlock = ((SplitJsonTableInputSource)inputSource).getTableBlock();
        } else if (inputSource instanceof SingleJsonTableInputSource) {
            tableBlock = ((SingleJsonTableInputSource)inputSource).getTableBlock();
        } else if (inputSource instanceof BlockInputSource) {
            Object block = ((BlockInputSource)inputSource).getBlock();
            tableBlock = (TableBlock)block;
        } else {
            this.setTableOriginalSource(inputSource);
            InputStream inputStream = inputSource.openStream();
            tableBlock = TableBlock.load(inputStream);
            inputStream.close();
        }
        BlockInputSource<TableBlock> blockInputSource = new BlockInputSource<TableBlock>(inputSource.getName(), tableBlock);
        blockInputSource.setMethod(inputSource.getMethod());
        blockInputSource.setSort(inputSource.getSort());
        this.zipEntryMap.add(blockInputSource);
        tableBlock.setApkFile(this);
        return tableBlock;
    }

    public void addAll(Collection<? extends InputSource> inputSources) {
        if (inputSources == null) {
            return;
        }
        for (InputSource inputSource : inputSources) {
            this.add(inputSource);
        }
    }

    public void add(InputSource inputSource) {
        if (inputSource == null) {
            return;
        }
        String path = inputSource.getAlias();
        if ("AndroidManifest.xml".equals(path)) {
            InputSource manifestSource = this.getManifestOriginalSource();
            if (manifestSource != inputSource) {
                this.mManifestBlock = null;
            }
            this.setManifestOriginalSource(inputSource);
        } else if ("resources.arsc".equals(path)) {
            InputSource table = this.getTableOriginalSource();
            if (inputSource != table) {
                this.mTableBlock = null;
            }
            this.setTableOriginalSource(inputSource);
        }
        this.addInputSource(inputSource);
    }

    public InputSource getInputSource(String path) {
        return this.getZipEntryMap().getInputSource(path);
    }

    private void addInputSource(InputSource inputSource) {
        this.getZipEntryMap().add(inputSource);
    }

    public List<InputSource> listInputSources() {
        return this.getZipEntryMap().listInputSources();
    }

    public InputSource[] getInputSources() {
        return this.getZipEntryMap().toArray();
    }

    public ZipEntryMap getZipEntryMap() {
        return this.zipEntryMap;
    }

    public void setLoadDefaultFramework(boolean loadDefaultFramework) {
        this.loadDefaultFramework = loadDefaultFramework;
        this.mDisableLoadFramework = !loadDefaultFramework;
    }

    public void merge(ApkModule module) throws IOException {
        if (module == null || module == this) {
            return;
        }
        this.logMessage("Merging: " + module.getModuleName());
        this.mergeDexFiles(module);
        this.mergeTable(module);
        this.mergeFiles(module);
        this.getUncompressedFiles().merge(module.getUncompressedFiles());
    }

    private void mergeTable(ApkModule module) {
        TableBlock exist;
        if (!module.hasTableBlock()) {
            return;
        }
        this.logMessage("Merging resource table: " + module.getModuleName());
        if (!this.hasTableBlock()) {
            exist = new TableBlock();
            BlockInputSource<TableBlock> inputSource = new BlockInputSource<TableBlock>("resources.arsc", exist);
            this.addInputSource(inputSource);
        } else {
            exist = this.getTableBlock();
        }
        TableBlock coming = module.getTableBlock();
        exist.merge(coming);
    }

    private void mergeFiles(ApkModule module) {
        ZipEntryMap entryMapExist = this.getZipEntryMap();
        ZipEntryMap entryMapComing = module.getZipEntryMap();
        LinkedHashMap<String, InputSource> comingAlias = entryMapComing.toAliasMap();
        LinkedHashMap<String, InputSource> existAlias = entryMapExist.toAliasMap();
        UncompressedFiles uncompressedFiles = module.getUncompressedFiles();
        for (InputSource inputSource : comingAlias.values()) {
            if (existAlias.containsKey(inputSource.getAlias()) || existAlias.containsKey(inputSource.getName()) || DexFileInputSource.isDexName(inputSource.getName())) continue;
            if (inputSource.getAlias().startsWith("lib/")) {
                uncompressedFiles.removePath(inputSource.getAlias());
            }
            this.logVerbose("Added: " + inputSource.getAlias());
            entryMapExist.add(inputSource);
        }
    }

    private void mergeDexFiles(ApkModule module) {
        UncompressedFiles uncompressedFiles = module.getUncompressedFiles();
        List<DexFileInputSource> existList = this.listDexFiles();
        List<DexFileInputSource> comingList = module.listDexFiles();
        ZipEntryMap zipEntryMap = this.getZipEntryMap();
        int index = 0;
        if (existList.size() > 0) {
            index = existList.get(existList.size() - 1).getDexNumber();
            index = index == 0 ? 2 : ++index;
        }
        for (DexFileInputSource source : comingList) {
            uncompressedFiles.removePath(source.getAlias());
            String name = DexFileInputSource.getDexName(index);
            DexFileInputSource add = new DexFileInputSource(name, (InputSource)source.getInputSource());
            zipEntryMap.add(add);
            this.logMessage("Added [" + module.getModuleName() + "] " + source.getAlias() + " -> " + name);
            if (++index != 1) continue;
            index = 2;
        }
    }

    public APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }

    public void setCloseable(Closeable closeable) {
        this.mCloseable = closeable;
    }

    @Override
    public void close() throws IOException {
        Closeable closeable = this.mCloseable;
        if (closeable != null) {
            closeable.close();
        }
    }

    public String toString() {
        return this.getModuleName();
    }

    public static ApkModule loadApkFile(File apkFile) throws IOException {
        return ApkModule.loadApkFile(apkFile, "base");
    }

    public static ApkModule loadApkFile(File apkFile, String moduleName) throws IOException {
        ArchiveFile archive = new ArchiveFile(apkFile);
        ApkModule apkModule = new ApkModule(moduleName, archive.createZipEntryMap());
        apkModule.setApkSignatureBlock(archive.getApkSignatureBlock());
        apkModule.setCloseable(archive);
        return apkModule;
    }

    public static ApkModule loadApkFile(File apkFile, File ... externalFrameworks) throws IOException {
        return ApkModule.loadApkFile(null, apkFile, externalFrameworks);
    }

    public static ApkModule loadApkFile(APKLogger logger, File apkFile, File ... externalFrameworks) throws IOException {
        ArchiveFile archive = new ArchiveFile(apkFile);
        ApkModule apkModule = new ApkModule("base", archive.createZipEntryMap());
        apkModule.setAPKLogger(logger);
        apkModule.setApkSignatureBlock(archive.getApkSignatureBlock());
        apkModule.setCloseable(archive);
        if (externalFrameworks == null || externalFrameworks.length == 0) {
            return apkModule;
        }
        for (File frameworkFile : externalFrameworks) {
            if (frameworkFile == null) continue;
            if (apkFile.equals(frameworkFile)) {
                throw new IOException("External framework should be different: " + apkFile);
            }
            apkModule.addExternalFramework(frameworkFile);
        }
        return apkModule;
    }

    public static ApkModule readApkBytes(byte[] bytes) throws IOException {
        ArchiveBytes archiveBytes = new ArchiveBytes(bytes);
        ApkModule apkModule = new ApkModule(archiveBytes.createZipEntryMap());
        apkModule.setModuleName("byte_" + System.currentTimeMillis());
        return apkModule;
    }
}

