/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.collection;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jf.util.collection.ArrayIterator;
import org.jf.util.collection.CombiningIterable;
import org.jf.util.collection.CombiningIterator;
import org.jf.util.collection.ComputeIterable;
import org.jf.util.collection.ComputeIterator;
import org.jf.util.collection.ConcatIterables;
import org.jf.util.collection.FilterIterable;
import org.jf.util.collection.FilterIterator;

public class Iterables {
    public static <T> T getLast(List<T> list) {
        if (list.size() > 0) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        return Iterables.getNext(iterable.iterator(), defaultValue);
    }

    public static <T> T getNext(Iterator<? extends T> iterator, T defaultValue) {
        return iterator.hasNext() ? iterator.next() : defaultValue;
    }

    public static <E, T extends E> Iterable<T> filter(Iterable<? extends T> iterable, Predicate<E> filter) {
        return new FilterIterable<E, T>(iterable, filter);
    }

    public static <T> Iterator<T> filter(Iterator<? extends T> iterator, Predicate<T> filter) {
        return new FilterIterator<T, T>(iterator, filter);
    }

    public static <T> Iterator<T> forArray(T ... array) {
        return new ArrayIterator<T>(array);
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        if (iterable == null) {
            return false;
        }
        for (T item : iterable) {
            if (!(predicate == null ? item != null : predicate.test(item))) continue;
            return true;
        }
        return false;
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b) {
        return new CombiningIterator<T>(a, b);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> iterable1, Iterable<? extends T> iterable2) {
        return new CombiningIterable<T>(iterable1, iterable2);
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> iterables) {
        return new ConcatIterables(iterables);
    }

    public static <E, T> Iterable<T> transform(Iterable<E> iterable, Function<? super E, ? extends T> function) {
        return new ComputeIterable<E, T>(iterable, function);
    }

    public static <E, T> Iterator<T> transform(Iterator<E> iterable, Function<? super E, ? extends T> function) {
        return new ComputeIterator<E, T>(iterable, function);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        return Iterables.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        if (iterator == null) {
            return true;
        }
        return !iterator.hasNext();
    }

    public static int size(Iterable<?> iterable) {
        return Iterables.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }
}

