/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.reference;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.base.reference.BaseCallSiteReference;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.util.EncodedArrayItemIterator;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.util.ExceptionWithContext;

public class DexBackedCallSiteReference
extends BaseCallSiteReference {
    @Nonnull
    public final DexBackedDexFile dexFile;
    public final int callSiteIndex;
    public final int callSiteIdOffset;
    private int callSiteOffset = -1;

    public DexBackedCallSiteReference(DexBackedDexFile dexFile, int callSiteIndex) {
        this.dexFile = dexFile;
        this.callSiteIndex = callSiteIndex;
        this.callSiteIdOffset = dexFile.getCallSiteSection().getOffset(callSiteIndex);
    }

    @Override
    @Nonnull
    public String getName() {
        return String.format("call_site_%d", this.callSiteIndex);
    }

    @Override
    @Nonnull
    public MethodHandleReference getMethodHandle() {
        EncodedArrayItemIterator iter = this.getCallSiteIterator();
        if (iter.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        EncodedValue encodedValue = this.getCallSiteIterator().getNextOrNull();
        assert (encodedValue != null);
        if (encodedValue.getValueType() != 22) {
            throw new ExceptionWithContext("Invalid encoded value type (%d) for the first item in call site %d", encodedValue.getValueType(), this.callSiteIndex);
        }
        return ((MethodHandleEncodedValue)encodedValue).getValue();
    }

    @Override
    @Nonnull
    public String getMethodName() {
        EncodedArrayItemIterator iter = this.getCallSiteIterator();
        if (iter.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        iter.skipNext();
        EncodedValue encodedValue = iter.getNextOrNull();
        assert (encodedValue != null);
        if (encodedValue.getValueType() != 23) {
            throw new ExceptionWithContext("Invalid encoded value type (%d) for the second item in call site %d", encodedValue.getValueType(), this.callSiteIndex);
        }
        return ((StringEncodedValue)encodedValue).getValue();
    }

    @Override
    @Nonnull
    public MethodProtoReference getMethodProto() {
        EncodedArrayItemIterator iter = this.getCallSiteIterator();
        if (iter.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        iter.skipNext();
        iter.skipNext();
        EncodedValue encodedValue = iter.getNextOrNull();
        assert (encodedValue != null);
        if (encodedValue.getValueType() != 21) {
            throw new ExceptionWithContext("Invalid encoded value type (%d) for the second item in call site %d", encodedValue.getValueType(), this.callSiteIndex);
        }
        return ((MethodTypeEncodedValue)encodedValue).getValue();
    }

    @Override
    @Nonnull
    public List<? extends EncodedValue> getExtraArguments() {
        ArrayList<EncodedValue> values = new ArrayList<EncodedValue>();
        EncodedArrayItemIterator iter = this.getCallSiteIterator();
        if (iter.getItemCount() < 3) {
            throw new ExceptionWithContext("Invalid call site item: must contain at least 3 entries.", new Object[0]);
        }
        if (iter.getItemCount() == 3) {
            return values;
        }
        iter.skipNext();
        iter.skipNext();
        iter.skipNext();
        EncodedValue item = iter.getNextOrNull();
        while (item != null) {
            values.add(item);
            item = iter.getNextOrNull();
        }
        return values;
    }

    private EncodedArrayItemIterator getCallSiteIterator() {
        return EncodedArrayItemIterator.newOrEmpty(this.dexFile, this.getCallSiteOffset());
    }

    private int getCallSiteOffset() {
        if (this.callSiteOffset < 0) {
            this.callSiteOffset = this.dexFile.getBuffer().readSmallUint(this.callSiteIdOffset);
        }
        return this.callSiteOffset;
    }

    @Override
    public void validateReference() throws Reference.InvalidReferenceException {
        if (this.callSiteIndex < 0 || this.callSiteIndex >= this.dexFile.getCallSiteSection().size()) {
            throw new Reference.InvalidReferenceException("callsite@" + this.callSiteIndex);
        }
    }
}

