/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.ArrayProto;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.analysis.DexClassProvider;
import org.jf.dexlib2.analysis.OdexedFieldInstructionMapper;
import org.jf.dexlib2.analysis.PrimitiveProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnknownClassProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.reflection.ReflectionClassDef;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.immutable.ImmutableDexFile;
import org.jf.util.collection.ListUtil;

public class ClassPath {
    @Nonnull
    private final TypeProto unknownClass;
    @Nonnull
    private List<ClassProvider> classProviders;
    private final boolean checkPackagePrivateAccess;
    public final int oatVersion;
    public static final int NOT_ART = -1;
    public static final int NOT_SPECIFIED = -2;
    private final Map<String, TypeProto> classLoader = new HashMap<String, TypeProto>(){

        @Override
        public TypeProto get(Object obj) {
            String type = obj.toString();
            TypeProto exist = (TypeProto)super.get(type);
            if (exist == null) {
                exist = this.loadProto(type);
                super.put(type, exist);
            }
            return exist;
        }

        private TypeProto loadProto(String type) {
            if (type.charAt(0) == '[') {
                return new ArrayProto(ClassPath.this, type);
            }
            return new ClassProto(ClassPath.this, type);
        }
    };
    private OdexedFieldInstructionMapper mapper;

    public ClassPath(ClassProvider ... classProviders) throws IOException {
        this(Arrays.asList(classProviders), false, -1);
    }

    public ClassPath(Iterable<ClassProvider> classProviders) throws IOException {
        this(classProviders, false, -1);
    }

    public ClassPath(@Nonnull Iterable<? extends ClassProvider> classProviders, boolean checkPackagePrivateAccess, int oatVersion) {
        this.unknownClass = new UnknownClassProto(this);
        this.classLoader.put(this.unknownClass.getType(), this.unknownClass);
        this.checkPackagePrivateAccess = checkPackagePrivateAccess;
        this.oatVersion = oatVersion;
        this.loadPrimitiveType("Z");
        this.loadPrimitiveType("B");
        this.loadPrimitiveType("S");
        this.loadPrimitiveType("C");
        this.loadPrimitiveType("I");
        this.loadPrimitiveType("J");
        this.loadPrimitiveType("F");
        this.loadPrimitiveType("D");
        this.loadPrimitiveType("L");
        this.classProviders = ListUtil.newArrayList(classProviders);
        this.classProviders.add(ClassPath.getBasicClasses());
    }

    private void loadPrimitiveType(String type) {
        this.classLoader.put(type, new PrimitiveProto(this, type));
    }

    private static ClassProvider getBasicClasses() {
        return new DexClassProvider(new ImmutableDexFile(Opcodes.getDefault(), ListUtil.of(new ReflectionClassDef(Class.class), new ReflectionClassDef(Cloneable.class), new ReflectionClassDef(Object.class), new ReflectionClassDef(Serializable.class), new ReflectionClassDef(String.class), new ReflectionClassDef(Throwable.class))));
    }

    public boolean isArt() {
        return this.oatVersion != -1;
    }

    @Nonnull
    public TypeProto getClass(@Nonnull CharSequence type) {
        return this.classLoader.get(type.toString());
    }

    @Nonnull
    public ClassDef getClassDef(String type) {
        for (ClassProvider provider : this.classProviders) {
            ClassDef classDef = provider.getClassDef(type);
            if (classDef == null) continue;
            return classDef;
        }
        throw new UnresolvedClassException("Could not resolve class %s", type);
    }

    @Nonnull
    public TypeProto getUnknownClass() {
        return this.unknownClass;
    }

    public boolean shouldCheckPackagePrivateAccess() {
        return this.checkPackagePrivateAccess;
    }

    @Nonnull
    public OdexedFieldInstructionMapper getFieldInstructionMapper() {
        if (this.mapper == null) {
            this.mapper = new OdexedFieldInstructionMapper(this.isArt());
        }
        return this.mapper;
    }
}

