/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLUtil {
    public static String NEW_LINE = "\n";
    public static String[] EVENT_TYPES = new String[]{"START_DOCUMENT", "END_DOCUMENT", "START_TAG", "END_TAG", "TEXT", "CDSECT", "ENTITY_REF", "IGNORABLE_WHITESPACE", "PROCESSING_INSTRUCTION", "COMMENT", "DOCDECL"};

    public static String splitName(String name) {
        if (name == null) {
            return null;
        }
        int i = name.lastIndexOf(58);
        if (i >= 0) {
            name = name.substring(++i);
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        return name;
    }

    public static String splitPrefix(String name) {
        if (name == null) {
            return null;
        }
        int i = name.indexOf(58);
        if (i > 0) {
            return name.substring(0, i);
        }
        return null;
    }

    public static int ensureStartTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event = parser.getEventType();
        while (event != 2 && event != 1) {
            event = parser.next();
        }
        return event;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    public static String escapeXmlChars(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(38) < 0 && str.indexOf(60) < 0 && str.indexOf(62) < 0) {
            return str;
        }
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        return str;
    }

    public static String escapeQuote(String str) {
        if (str == null) {
            return null;
        }
        int i = str.indexOf(34);
        if (i < 0) {
            return str;
        }
        str = str.replaceAll("\"", "&quot;");
        return str;
    }

    public static String unEscapeXmlChars(String str) {
        if (str == null) {
            return null;
        }
        int i = str.indexOf(38);
        if (i < 0) {
            return str;
        }
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "\"");
        return str;
    }

    public static String trimQuote(String txt) {
        if (txt == null) {
            return null;
        }
        String tmp = txt.trim();
        if (tmp.length() == 0) {
            return txt;
        }
        char c1 = tmp.charAt(0);
        if (c1 != '\"') {
            return txt;
        }
        int end = tmp.length() - 1;
        c1 = tmp.charAt(end);
        if (c1 != '\"') {
            return txt;
        }
        if (end <= 1) {
            return "";
        }
        return tmp.substring(1, end);
    }

    public static String toEventName(int eventType) {
        String[] types = EVENT_TYPES;
        if (eventType < 0 || eventType >= types.length) {
            return String.valueOf(eventType);
        }
        return types[eventType];
    }
}

