/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.common.FileChannelInputStream;
import com.reandroid.xml.CloseableParser;
import com.reandroid.xml.CloseableSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLFactory {
    public static XmlPullParser newPullParser(String xmlContent) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        StringReader reader = new StringReader(xmlContent);
        parser.setInput(reader);
        return parser;
    }

    public static XmlPullParser newPullParser(File file) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        try {
            parser.setInput(new FileChannelInputStream(file), StandardCharsets.UTF_8.name());
        }
        catch (IOException ex) {
            throw new XmlPullParserException(ex.getMessage());
        }
        return parser;
    }

    public static XmlPullParser newPullParser(Reader reader) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        parser.setInput(reader);
        return parser;
    }

    public static XmlPullParser newPullParser(InputStream inputStream) throws XmlPullParserException {
        XmlPullParser parser = XMLFactory.newPullParser();
        parser.setInput(inputStream, StandardCharsets.UTF_8.name());
        return parser;
    }

    public static XmlPullParser newPullParser() {
        return new CloseableParser();
    }

    public static XmlSerializer newSerializer(Writer writer) throws IOException {
        XmlSerializer serializer = XMLFactory.newSerializer();
        serializer.setOutput(writer);
        return serializer;
    }

    public static XmlSerializer newSerializer(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        return XMLFactory.newSerializer(new FileOutputStream(file));
    }

    public static XmlSerializer newSerializer(OutputStream outputStream) throws IOException {
        XmlSerializer serializer = XMLFactory.newSerializer();
        serializer.setOutput(outputStream, StandardCharsets.UTF_8.name());
        return serializer;
    }

    public static XmlSerializer newSerializer() {
        return new CloseableSerializer();
    }
}

