/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLNamespace;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLElement
extends XMLNodeTree {
    private ArrayList<XMLAttribute> mAttributes = EMPTY_ATTRIBUTES;
    private String mName;
    private XMLNamespace mNamespace;
    private ArrayList<XMLNamespace> mNamespaceList = EMPTY_NAMESPACES;
    private static final ArrayList<XMLAttribute> EMPTY_ATTRIBUTES = new ArrayList();
    private static final ArrayList<XMLNamespace> EMPTY_NAMESPACES = new ArrayList();

    public XMLElement() {
    }

    public XMLElement(String tagName) {
        this();
        this.setName(tagName);
    }

    @Override
    XMLElement clone(XMLNode parent) {
        int i;
        XMLElement element = this.newElement();
        if (parent instanceof XMLNodeTree) {
            ((XMLNodeTree)parent).add(element);
        }
        int count = this.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            this.getNamespaceAt(i).clone(element);
        }
        this.setName(this.getUri(), this.getPrefix(), this.getName(false));
        count = this.getAttributeCount();
        for (i = 0; i < count; ++i) {
            element.addAttribute(this.getAttributeAt(i).clone(element));
        }
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().clone(element);
        }
        return element;
    }

    public void addText(String text) {
        XMLText xmlText = this.newText();
        xmlText.setText(text);
        this.add(xmlText);
    }

    public XMLAttribute getAttributeAt(int index) {
        return this.mAttributes.get(index);
    }

    public Iterator<? extends XMLAttribute> getAttributes() {
        return new IndexIterator<XMLAttribute>(new SizedSupplier<XMLAttribute>(){

            @Override
            public int size() {
                return XMLElement.this.getAttributeCount();
            }

            @Override
            public XMLAttribute get(int index) {
                return XMLElement.this.getAttributeAt(index);
            }
        });
    }

    public String getUri() {
        XMLNamespace namespace = this.getNamespace();
        if (namespace != null) {
            return namespace.getUri();
        }
        return null;
    }

    public String getPrefix() {
        XMLNamespace namespace = this.getNamespace();
        if (namespace != null) {
            return namespace.getUri();
        }
        return null;
    }

    public XMLNamespace getNamespace() {
        return this.mNamespace;
    }

    public void setNamespace(XMLNamespace namespace) {
        this.mNamespace = namespace;
    }

    public void setNamespace(String uri, String prefix) {
        this.setNamespace(this.getOrCreateXMLNamespace(uri, prefix));
    }

    public int getNamespaceCount() {
        return this.mNamespaceList.size();
    }

    public XMLNamespace getNamespaceAt(int index) {
        return this.mNamespaceList.get(index);
    }

    public void addNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return;
        }
        this.addNamespace(new XMLNamespace(uri, prefix));
    }

    public void addNamespace(XMLNamespace namespace) {
        if (namespace != null && !this.mNamespaceList.contains(namespace)) {
            if (this.mNamespaceList == EMPTY_NAMESPACES) {
                this.mNamespaceList = new ArrayList(2);
            } else if (this.mNamespaceList.contains(namespace)) {
                return;
            }
            this.mNamespaceList.add(namespace);
        }
    }

    public XMLNamespace getOrCreateXMLNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        XMLNamespace namespace = this.getXMLNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        namespace = new XMLNamespace(uri, prefix);
        this.getRootElement().addNamespace(namespace);
        return namespace;
    }

    public XMLNamespace getXMLNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            if (!namespace.isEqual(uri, prefix)) continue;
            return namespace;
        }
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getXMLNamespace(uri, prefix);
        }
        return null;
    }

    public XMLNamespace getXMLNamespaceByUri(String uri) {
        if (uri == null) {
            return null;
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            if (!uri.equals(namespace.getUri())) continue;
            return namespace;
        }
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getXMLNamespaceByUri(uri);
        }
        return null;
    }

    public XMLNamespace getXMLNamespaceByPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            if (!prefix.equals(namespace.getPrefix())) continue;
            return namespace;
        }
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getXMLNamespaceByPrefix(prefix);
        }
        return null;
    }

    public Collection<XMLAttribute> listAttributes() {
        return this.mAttributes;
    }

    public int getChildElementsCount() {
        return super.size(XMLElement.class);
    }

    public List<XMLElement> getChildElementList() {
        return CollectionUtil.toList(this.iterator(XMLElement.class));
    }

    public XMLElement getElement(String name) {
        return CollectionUtil.getFirst(this.getElements(name));
    }

    public Iterator<? extends XMLElement> getElements() {
        return this.iterator(XMLElement.class);
    }

    public Iterator<XMLElement> getElements(Predicate<XMLElement> filter) {
        return this.iterator(XMLElement.class, filter);
    }

    public Iterator<XMLElement> getElements(String name) {
        return this.getElements((XMLElement element) -> element.equalsName(name));
    }

    public int getAttributeCount() {
        return this.mAttributes.size();
    }

    public String getAttributeValue(String name) {
        XMLAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public XMLAttribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        int count = this.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            XMLAttribute attribute = this.getAttributeAt(i);
            if (!attribute.equalsName(name)) continue;
            return attribute;
        }
        return null;
    }

    public void clearAttributes() {
        if (this.mAttributes.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mAttributes.size(); ++i) {
            XMLAttribute attribute = this.mAttributes.get(i);
            attribute.setParent(null);
        }
        this.mAttributes.clear();
        this.mAttributes.trimToSize();
    }

    public XMLAttribute removeAttribute(String name) {
        XMLAttribute attribute = this.getAttribute(name);
        if (attribute != null) {
            attribute.setParent(null);
        }
        return attribute;
    }

    public XMLAttribute removeAttribute(XMLAttribute attribute) {
        if (this.mAttributes.remove(attribute) && attribute != null) {
            attribute.setParent(null);
        }
        return attribute;
    }

    public XMLAttribute removeAttributeAt(int index) {
        XMLAttribute attribute = this.mAttributes.remove(index);
        if (attribute != null) {
            attribute.setParent(null);
        }
        return attribute;
    }

    public XMLAttribute setAttribute(String name, String value) {
        if (XMLUtil.isEmpty(name)) {
            return null;
        }
        XMLAttribute xmlAttribute = this.getAttribute(name);
        if (xmlAttribute == null) {
            if (XMLNamespace.looksNamespace(name, value)) {
                XMLNamespace namespace = new XMLNamespace(value, XMLUtil.splitName(name));
                this.addNamespace(namespace);
            } else {
                this.addAttribute(this.newAttribute().set(name, value));
            }
        } else {
            xmlAttribute.setValue(value);
        }
        return xmlAttribute;
    }

    public void addAttribute(String name, String value) {
        if (XMLUtil.isEmpty(name)) {
            return;
        }
        if (XMLNamespace.looksNamespace(name, value)) {
            XMLNamespace namespace = new XMLNamespace(value, XMLUtil.splitName(name));
            this.addNamespace(namespace);
        } else {
            this.addAttribute(this.newAttribute().set(name, value));
        }
    }

    public void addAttribute(String uri, String prefix, String name, String value) {
        if (XMLUtil.isEmpty(name)) {
            return;
        }
        if (XMLNamespace.looksNamespace(name, value)) {
            XMLNamespace namespace = new XMLNamespace(value, XMLUtil.splitName(name));
            this.addNamespace(namespace);
        } else {
            XMLAttribute attribute = new XMLAttribute();
            this.addAttribute(attribute);
            attribute.setName(uri, prefix, name);
            attribute.setValue(value);
        }
    }

    public void addAttribute(XMLAttribute xmlAttribute) {
        if (xmlAttribute == null) {
            return;
        }
        if (this.mAttributes == EMPTY_ATTRIBUTES) {
            this.mAttributes = new ArrayList(1);
        }
        this.mAttributes.add(xmlAttribute);
        xmlAttribute.setParent(this);
    }

    public XMLElement getParentElement() {
        XMLNode parent = this.getParent();
        if (parent instanceof XMLElement) {
            return (XMLElement)parent;
        }
        return null;
    }

    public XMLElement getRootElement() {
        XMLElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getRootElement();
        }
        return this;
    }

    public XMLDocument getParentDocument() {
        XMLElement root = this.getRootElement();
        XMLNode parent = root.getParent();
        if (parent instanceof XMLDocument) {
            return (XMLDocument)parent;
        }
        return null;
    }

    public int getDepth() {
        int result = 0;
        for (XMLElement parent = this.getParentElement(); parent != null; parent = parent.getParentElement()) {
            ++result;
        }
        return result;
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        String prefix = XMLUtil.splitPrefix(name);
        if (prefix != null && !prefix.equals(this.getPrefix())) {
            return false;
        }
        return name.equals(this.getName());
    }

    public String getName() {
        return this.mName;
    }

    public String getName(boolean includePrefix) {
        String name = this.getName();
        if (!includePrefix) {
            return name;
        }
        String prefix = this.getPrefix();
        if (prefix != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    public void setName(String name) {
        this.setName(null, null, name);
    }

    public void setName(String uri, String name) {
        this.setName(uri, null, name);
    }

    public void setName(String uri, String prefix, String name) {
        XMLNamespace namespace;
        this.mName = XMLUtil.splitName(name);
        if (prefix == null) {
            prefix = XMLUtil.splitPrefix(name);
        }
        if (XMLUtil.isEmpty(uri)) {
            uri = null;
        }
        if (uri == null && prefix == null) {
            return;
        }
        if (uri == null) {
            namespace = this.getXMLNamespaceByPrefix(prefix);
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace not found for prefix: " + prefix);
            }
        } else {
            namespace = this.getXMLNamespaceByUri(uri);
            if (namespace == null) {
                throw new IllegalArgumentException("Namespace not found for uri: " + uri);
            }
        }
        this.setNamespace(namespace);
    }

    public String getTextContent() {
        return this.getTextContent(false);
    }

    public String getTextContent(boolean escapeXmlText) {
        StringWriter writer = new StringWriter();
        try {
            for (XMLNode child : this) {
                child.write(writer, true, escapeXmlText);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public boolean hasChildElements() {
        return !CollectionUtil.isEmpty(this.getElements());
    }

    public boolean hasTextNode() {
        return !CollectionUtil.isEmpty(this.iterator(XMLText.class));
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public void setTextContent(String text, boolean escape) {
        super.clear();
        if (escape) {
            text = XMLUtil.escapeXmlChars(text);
        }
        this.addText(text);
    }

    @Override
    void startSerialize(XmlSerializer serializer) throws IOException {
        int i;
        int count = this.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            XMLNamespace namespace = this.getNamespaceAt(i);
            serializer.setPrefix(namespace.getPrefix(), namespace.getUri());
        }
        serializer.startTag(this.getUri(), this.getName(false));
        count = this.getAttributeCount();
        for (i = 0; i < count; ++i) {
            this.getAttributeAt(i).serialize(serializer);
        }
    }

    @Override
    void endSerialize(XmlSerializer serializer) throws IOException {
        serializer.endTag(this.getUri(), this.getName(false));
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        if (event != 2) {
            throw new XmlPullParserException("Not START_TAG event");
        }
        this.parseNamespaces(parser);
        this.setName(parser.getNamespace(), parser.getPrefix(), parser.getName());
        this.parseAttributes(parser);
        event = parser.next();
        XMLText xmlText = null;
        while (event != 3 && event != 1) {
            if (event == 2) {
                XMLElement element = this.newElement();
                this.add(element);
                element.parse(parser);
                xmlText = null;
            } else if (XMLText.isTextEvent(event)) {
                if (xmlText == null) {
                    xmlText = this.newText();
                }
                xmlText.parse(parser);
                if (!xmlText.isIndent()) {
                    this.add(xmlText);
                }
            } else if (event == 9) {
                XMLComment comment = this.newComment();
                if (comment != null) {
                    this.add(comment);
                    comment.parse(parser);
                } else {
                    parser.next();
                }
                xmlText = null;
            } else {
                xmlText = null;
                parser.next();
            }
            event = parser.getEventType();
        }
        if (parser.getEventType() == 3) {
            parser.next();
        }
    }

    private void parseNamespaces(XmlPullParser parser) throws XmlPullParserException {
        int i;
        int count = parser.getNamespaceCount(this.getDepth());
        for (i = 0; i < count; ++i) {
            this.addNamespace(parser.getNamespaceUri(i), parser.getNamespacePrefix(i));
        }
        count = parser.getAttributeCount();
        for (i = 0; i < count; ++i) {
            String value;
            String name = parser.getAttributeName(i);
            if (!XMLNamespace.looksNamespace(name, value = parser.getAttributeValue(i))) continue;
            this.addNamespace(value, XMLUtil.splitName(name));
        }
    }

    public void parseAttributes(XmlPullParser parser) {
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String value;
            String name = parser.getAttributeName(i);
            if (XMLNamespace.looksNamespace(name, value = parser.getAttributeValue(i))) continue;
            String uri = parser.getAttributeNamespace(i);
            String prefix = parser.getAttributePrefix(i);
            this.addAttribute(uri, prefix, name, value);
        }
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        appendable.append('<');
        appendable.append(this.getName());
        this.appendAttributes(appendable, xml, escapeXmlText);
        boolean haveChildes = false;
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!haveChildes) {
                appendable.append(">");
            }
            XMLNode child = iterator.next();
            child.write(appendable, xml, escapeXmlText);
            haveChildes = true;
        }
        if (haveChildes) {
            appendable.append("</");
            appendable.append(this.getName());
            appendable.append('>');
        } else {
            appendable.append("/>");
        }
    }

    void appendAttributes(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        char separator = xml ? (char)' ' : ';';
        boolean appendFirst = false;
        Iterator<? extends XMLAttribute> iterator = this.getAttributes();
        while (iterator.hasNext()) {
            if (!appendFirst) {
                appendable.append(' ');
            } else {
                appendable.append(separator);
            }
            appendFirst = true;
            iterator.next().write(appendable, xml, escapeXmlText);
        }
    }

    @Override
    int appendDebugText(Appendable appendable, int limit, int length) throws IOException {
        if (length >= limit) {
            return length;
        }
        appendable.append('<');
        ++length;
        String name = this.getName(true);
        if (name == null) {
            name = "null";
        }
        appendable.append(name);
        length += name.length();
        Iterator<? extends XMLAttribute> attributes = this.getAttributes();
        while (attributes.hasNext() && length < limit) {
            appendable.append(' ');
            ++length;
            length = attributes.next().appendDebugText(appendable, limit, length);
        }
        boolean hasChildes = false;
        Iterator<XMLNode> iterator = this.iterator();
        while (iterator.hasNext() && length < limit) {
            if (!hasChildes) {
                appendable.append("/>");
                length += 2;
            }
            length = iterator.next().appendDebugText(appendable, limit, length);
            hasChildes = true;
        }
        if (hasChildes) {
            appendable.append("</");
            appendable.append(name);
            length += name.length();
            appendable.append('>');
            length += 3;
        } else {
            appendable.append("/>");
            length += 2;
        }
        return length;
    }

    public static XMLElement parseElement(XmlPullParser parser) throws IOException, XmlPullParserException {
        XMLElement element = new XMLElement();
        element.parse(parser);
        return element;
    }

    public static Iterator<XMLElement> iterateElements(XmlPullParser parser) throws IOException, XmlPullParserException {
        return new Iterator<XMLElement>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public XMLElement next() {
                return null;
            }
        };
    }
}

