/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XMLComment
extends XMLNode {
    private String text;

    public XMLComment(String text) {
        this();
        this.setText(text);
    }

    public XMLComment() {
    }

    @Override
    XMLComment clone(XMLNode parent) {
        XMLComment comment = new XMLComment();
        comment.setText(this.getText());
        return comment;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.getText(false);
    }

    public String getText(boolean escapeXmlText) {
        String text = this.text;
        if (escapeXmlText) {
            return XMLUtil.escapeXmlChars(text);
        }
        return text;
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.comment(this.getText(false));
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 9) {
            throw new XmlPullParserException("Invalid event, expecting COMMENT but found " + parser.getEventType());
        }
        this.setText(parser.getText());
        parser.next();
    }

    @Override
    void write(Appendable appendable, boolean xml, boolean escapeXmlText) throws IOException {
        appendable.append("<!-- ");
        appendable.append(this.getText(escapeXmlText));
        appendable.append(" -->");
    }

    @Override
    int appendDebugText(Appendable appendable, int limit, int length) throws IOException {
        if (length >= limit) {
            return length;
        }
        String text = this.getText();
        if (text != null) {
            appendable.append(text);
            length += text.length();
        }
        return length;
    }
}

