/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.StyleAttribute;
import com.reandroid.xml.StyleNode;
import com.reandroid.xml.StyleText;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLNodeTree;
import com.reandroid.xml.XMLText;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class StyleElement
extends XMLElement
implements StyleNode {
    public StyleElement(String name) {
        super(name);
    }

    public StyleElement() {
        this("");
    }

    @Override
    public StyleElement getParentElement() {
        return (StyleElement)super.getParentElement();
    }

    void copyFrom(XMLElement xmlElement) {
        this.setName(xmlElement.getName());
        Iterator<? extends XMLAttribute> attributes = xmlElement.getAttributes();
        while (attributes.hasNext()) {
            this.addAttribute(new StyleAttribute(attributes.next()));
        }
        for (XMLNode xmlNode : xmlElement) {
            if (xmlNode instanceof XMLElement) {
                StyleElement styleElement = this.newElement();
                this.add(styleElement);
                styleElement.copyFrom((XMLElement)xmlNode);
                continue;
            }
            if (!(xmlNode instanceof XMLText)) continue;
            XMLText xmlText = (XMLText)xmlNode;
            StyleText styleText = new StyleText(xmlText.getText());
            this.add(styleText);
        }
    }

    @Override
    public StyleAttribute getAttributeAt(int i) {
        return (StyleAttribute)super.getAttributeAt(i);
    }

    public void addAttribute(StyleAttribute attribute) {
        super.addAttribute(attribute);
    }

    @Override
    public StyleAttribute getAttribute(String name) {
        return (StyleAttribute)super.getAttribute(name);
    }

    public void addElement(StyleElement element) {
        this.add(element);
    }

    public Iterator<StyleElement> getElements() {
        return this.iterator(StyleElement.class);
    }

    public Iterator<StyleAttribute> getAttributes() {
        return new IndexIterator<StyleAttribute>(new SizedSupplier<StyleAttribute>(){

            @Override
            public int size() {
                return StyleElement.this.getAttributeCount();
            }

            @Override
            public StyleAttribute get(int index) {
                return StyleElement.this.getAttributeAt(index);
            }
        });
    }

    public String getStyleableTag() {
        StringWriter writer = new StringWriter();
        writer.write(this.getName());
        try {
            this.appendAttributes(writer, false, false);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public int getStart() {
        XMLNode parent = this.getParent();
        if (parent == null) {
            return 0;
        }
        int result = 0;
        for (XMLNode child : (XMLNodeTree)parent) {
            if (child == this) break;
            result += child.getLength();
        }
        return result;
    }

    public int getEnd() {
        return this.getEnd(this.getStart());
    }

    private int getEnd(int start) {
        int result = start;
        for (XMLNode child : this) {
            if (child == this) break;
            result += child.getLength();
        }
        if (result >= start) {
            --result;
        }
        return result;
    }

    @Override
    public int getLength() {
        int result = 0;
        for (XMLNode child : this) {
            result += child.getLength();
        }
        return result;
    }

    void writeStyledText(Appendable appendable) throws IOException {
        for (XMLNode xmlNode : this) {
            if (xmlNode instanceof StyleText) {
                StyleText styleText = (StyleText)xmlNode;
                styleText.writeStyledText(appendable);
                continue;
            }
            if (!(xmlNode instanceof StyleElement)) continue;
            StyleElement element = (StyleElement)xmlNode;
            element.writeStyledText(appendable);
        }
    }

    @Override
    public void appendChar(char ch) {
        StyleText styleText;
        if (ch == '\u0000') {
            return;
        }
        XMLNode xmlNode = this.getLast();
        if (xmlNode instanceof StyleText) {
            styleText = (StyleText)xmlNode;
        } else {
            styleText = new StyleText();
            this.add(styleText);
        }
        styleText.appendChar(ch);
    }

    @Override
    public StyleNode getParentStyle() {
        return (StyleNode)((Object)this.getParent());
    }

    @Override
    public void addStyleNode(StyleNode styleNode) {
        this.add((XMLNode)((Object)styleNode));
    }

    @Override
    void startSerialize(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, this.getName());
        Iterator<StyleAttribute> itr = this.getAttributes();
        while (itr.hasNext()) {
            itr.next().serialize(serializer);
        }
    }

    @Override
    void endSerialize(XmlSerializer serializer) throws IOException {
        serializer.endTag(null, this.getName());
    }

    @Override
    public void parse(XmlPullParser parser) throws XmlPullParserException, IOException {
        int event = parser.getEventType();
        if (event != 2) {
            throw new XmlPullParserException("Not START_TAG event");
        }
        this.setName(parser.getName());
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            this.addAttribute(new StyleAttribute(parser.getAttributeName(i), parser.getAttributeValue(i)));
        }
        event = parser.next();
        while (event != 3 && event != 1) {
            if (event == 2) {
                StyleElement element = new StyleElement();
                this.addElement(element);
                element.parse(parser);
            } else if (XMLText.isTextEvent(event)) {
                StyleText styleText = this.newText();
                this.add(styleText);
                styleText.parse(parser);
            } else {
                parser.next();
            }
            event = parser.getEventType();
        }
        if (parser.getEventType() == 3) {
            parser.next();
        }
    }

    @Override
    StyleElement newElement() {
        return new StyleElement();
    }

    @Override
    StyleText newText() {
        return new StyleText();
    }

    @Override
    XMLComment newComment() {
        return null;
    }

    @Override
    StyleAttribute newAttribute() {
        return new StyleAttribute();
    }

    @Override
    public String toString() {
        return "[" + this.getStart() + ", " + this.getEnd() + "] " + this.getStyleableTag();
    }
}

