/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class MergingIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> iteratorIterator;
    private Iterator<T> mCurrent;

    public MergingIterator(Iterator<Iterator<T>> iteratorIterator) {
        this.iteratorIterator = iteratorIterator;
    }

    @Override
    public boolean hasNext() {
        Iterator<T> current = this.getCurrent();
        return current != null && current.hasNext();
    }

    @Override
    public T next() {
        Iterator<T> current = this.getCurrent();
        if (current == null) {
            throw new NoSuchElementException();
        }
        return current.next();
    }

    private Iterator<T> getCurrent() {
        Iterator<T> current = this.mCurrent;
        while (current == null || !current.hasNext()) {
            if (!this.iteratorIterator.hasNext()) {
                return null;
            }
            current = this.iteratorIterator.next();
        }
        this.mCurrent = current;
        return current;
    }
}

