/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilterIterator<T>
implements Iterator<T>,
Predicate<T> {
    private final Iterator<? extends T> iterator;
    private T mNext;
    private final Predicate<? super T> mFilter;

    public FilterIterator(Iterator<? extends T> iterator, Predicate<? super T> filter) {
        this.iterator = iterator;
        this.mFilter = filter;
    }

    public FilterIterator(Iterator<? extends T> iterator) {
        this(iterator, null);
    }

    @Override
    public boolean test(T item) {
        return item != null;
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public T next() {
        T item = this.getNext();
        if (item == null) {
            throw new NoSuchElementException();
        }
        this.mNext = null;
        return item;
    }

    private T getNext() {
        if (this.mNext == null) {
            while (this.iterator.hasNext()) {
                T item = this.iterator.next();
                if (!this.testAll(item)) continue;
                this.mNext = item;
                break;
            }
        }
        return this.mNext;
    }

    private boolean testAll(T item) {
        if (item == null || !this.test(item)) {
            return false;
        }
        return this.mFilter == null || this.mFilter.test(item);
    }

    public static <T1> Iterator<T1> of(Iterator<? extends T1> iterator, Predicate<? super T1> filter) {
        if (iterator == null || !iterator.hasNext()) {
            return EmptyIterator.of();
        }
        return new FilterIterator<T1>(iterator, filter);
    }

    public static final class Except<T1>
    extends FilterIterator<T1> {
        private final T1 excludeItem;
        private final boolean useEquals;

        public Except(Iterator<? extends T1> iterator, T1 excludeItem, boolean useEquals) {
            super(iterator);
            this.excludeItem = excludeItem;
            this.useEquals = useEquals;
        }

        public Except(Iterator<? extends T1> iterator, T1 excludeItem) {
            this(iterator, (T1)excludeItem, false);
        }

        @Override
        public boolean test(T1 item) {
            if (item == null || item == this.excludeItem) {
                return false;
            }
            if (!this.useEquals) {
                return true;
            }
            return item.equals(this.excludeItem);
        }
    }
}

