/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.SizedItem;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class ArrayIterator<T>
implements Iterator<T>,
SizedItem {
    private final T[] elements;
    private final Predicate<T> mTester;
    private int index;
    private T mNext;

    public ArrayIterator(T[] elements, Predicate<T> tester) {
        this.elements = elements;
        this.mTester = tester;
    }

    public ArrayIterator(T[] elements) {
        this(elements, null);
    }

    @Override
    public int size() {
        if (this.elements != null) {
            return this.elements.length;
        }
        return 0;
    }

    @Override
    public boolean hasNext() {
        return this.getNext() != null;
    }

    @Override
    public T next() {
        T item = this.getNext();
        if (item == null) {
            throw new NoSuchElementException();
        }
        this.mNext = null;
        return item;
    }

    private T getNext() {
        T[] elements = this.elements;
        if (this.mNext == null && elements != null) {
            while (this.index < elements.length) {
                T item = elements[this.index];
                ++this.index;
                if (!this.testAll(item)) continue;
                this.mNext = item;
                break;
            }
        }
        return this.mNext;
    }

    private boolean testAll(T item) {
        if (item == null) {
            return false;
        }
        return this.mTester == null || this.mTester.test(item);
    }
}

