/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.identifiers;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.identifiers.Identifier;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.ResourceIdentifier;
import com.reandroid.utils.StringsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TableIdentifier {
    private final List<PackageIdentifier> mPackages = new ArrayList<PackageIdentifier>();
    private final Map<String, PackageIdentifier> mNameMap = new HashMap<String, PackageIdentifier>();
    private boolean mCaseInsensitive = Identifier.CASE_INSENSITIVE_FS;

    public void load(TableBlock tableBlock) {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.load(packageBlock);
        }
    }

    public PackageIdentifier load(PackageBlock packageBlock) {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.load(packageBlock);
        this.add(packageIdentifier);
        this.mNameMap.put(packageIdentifier.getName(), packageIdentifier);
        return packageIdentifier;
    }

    public void setTableBlock(TableBlock tableBlock) {
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            int id = packageBlock.getId();
            for (PackageIdentifier pi : this.getPackages()) {
                if (pi.getId() != id) continue;
                pi.setPackageBlock(packageBlock);
            }
        }
    }

    public void writeAllPublicXml(File resourcesDirectory) throws IOException {
        List<PackageIdentifier> packageList = this.getPackages();
        int index = 0;
        for (PackageIdentifier pi : this.getPackages()) {
            PackageBlock packageBlock = pi.getPackageBlock();
            String packageDir = packageBlock != null ? packageBlock.buildDecodeDirectoryName() : "package_" + StringsUtil.formatNumber(++index, packageList.size());
            File file = this.toPublicXmlFile(resourcesDirectory, packageDir);
            pi.writePublicXml(file);
        }
    }

    private File toPublicXmlFile(File resourcesDirectory, String packageDir) {
        File file = new File(resourcesDirectory, packageDir);
        file = new File(file, "res");
        file = new File(file, "values");
        file = new File(file, "public.xml");
        return file;
    }

    public void loadPublicXml(Collection<File> pubXmlFileList) throws IOException {
        for (File file : pubXmlFileList) {
            try {
                this.loadPublicXml(file);
            }
            catch (XmlPullParserException ex) {
                throw new IOException(ex);
            }
        }
    }

    public PackageIdentifier loadPublicXml(File file) throws IOException, XmlPullParserException {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.loadPublicXml(file);
        this.add(packageIdentifier);
        packageIdentifier.setTag(file);
        return packageIdentifier;
    }

    public PackageIdentifier loadPublicXml(InputStream inputStream) throws IOException, XmlPullParserException {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.loadPublicXml(inputStream);
        this.add(packageIdentifier);
        return packageIdentifier;
    }

    public PackageIdentifier loadPublicXml(Reader reader) throws IOException, XmlPullParserException {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.loadPublicXml(reader);
        this.add(packageIdentifier);
        return packageIdentifier;
    }

    public PackageIdentifier loadPublicXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        PackageIdentifier packageIdentifier = new PackageIdentifier();
        packageIdentifier.loadPublicXml(parser);
        this.add(packageIdentifier);
        return packageIdentifier;
    }

    public ResourceIdentifier get(String packageName, String type, String name) {
        ResourceIdentifier ri;
        PackageIdentifier packageIdentifier = this.mNameMap.get(packageName);
        if (packageIdentifier != null && (ri = packageIdentifier.getResourceIdentifier(type, name)) != null) {
            return ri;
        }
        for (PackageIdentifier pi : this.getPackages()) {
            ResourceIdentifier ri2;
            if (!Objects.equals(packageName, pi.getName()) || (ri2 = pi.getResourceIdentifier(type, name)) == null) continue;
            return ri2;
        }
        return null;
    }

    public ResourceIdentifier get(String type, String name) {
        for (PackageIdentifier pi : this.getPackages()) {
            ResourceIdentifier ri = pi.getResourceIdentifier(type, name);
            if (ri == null) continue;
            return ri;
        }
        return null;
    }

    public int countPackages() {
        return this.getPackages().size();
    }

    public void add(PackageIdentifier packageIdentifier) {
        if (packageIdentifier != null) {
            this.mPackages.add(packageIdentifier);
            packageIdentifier.setCaseInsensitive(this.isCaseInsensitive());
        }
    }

    public List<PackageIdentifier> getPackages() {
        return this.mPackages;
    }

    public PackageIdentifier getByTag(Object tag) {
        for (PackageIdentifier pi : this.getPackages()) {
            if (!Objects.equals(tag, pi.getTag())) continue;
            return pi;
        }
        return null;
    }

    public PackageIdentifier getByPackage(PackageBlock packageBlock) {
        for (PackageIdentifier pi : this.getPackages()) {
            if (packageBlock != pi.getPackageBlock()) continue;
            return pi;
        }
        return null;
    }

    public PackageIdentifier get(int packageId) {
        for (PackageIdentifier pi : this.getPackages()) {
            if (packageId != pi.getId()) continue;
            return pi;
        }
        return null;
    }

    public List<PackageIdentifier> getAll(String packageName) {
        ArrayList<PackageIdentifier> results = new ArrayList<PackageIdentifier>();
        for (PackageIdentifier pi : this.getPackages()) {
            if (!Objects.equals(packageName, pi.getName())) continue;
            results.add(pi);
        }
        return results;
    }

    public List<PackageIdentifier> getAll(int packageId) {
        ArrayList<PackageIdentifier> results = new ArrayList<PackageIdentifier>();
        for (PackageIdentifier pi : this.getPackages()) {
            if (packageId != pi.getId()) continue;
            results.add(pi);
        }
        return results;
    }

    public void clear() {
        for (PackageIdentifier identifier : this.getPackages()) {
            identifier.clear();
        }
        this.mPackages.clear();
        this.mNameMap.clear();
    }

    public int renameSpecs() {
        int result = 0;
        for (PackageIdentifier pi : this.getPackages()) {
            int renamed = pi.renameSpecs();
            result += renamed;
        }
        return result;
    }

    public int renameDuplicateSpecs() {
        this.updateCaseInsensitive(this.isCaseInsensitive());
        int result = 0;
        for (PackageIdentifier pi : this.getPackages()) {
            int renamed = pi.renameDuplicateSpecs();
            result += renamed;
        }
        return result;
    }

    public int renameBadSpecs() {
        int result = 0;
        for (PackageIdentifier pi : this.getPackages()) {
            int renamed = pi.renameBadSpecs();
            result += renamed;
        }
        return result;
    }

    public String validateSpecNames() {
        int duplicates = this.renameDuplicateSpecs();
        int bad = this.renameBadSpecs();
        if (duplicates == 0 && bad == 0) {
            return null;
        }
        return "Spec names validated, duplicates = " + duplicates + ", bad = " + bad;
    }

    public boolean isCaseInsensitive() {
        return this.mCaseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.mCaseInsensitive = caseInsensitive;
        this.updateCaseInsensitive(caseInsensitive);
    }

    private void updateCaseInsensitive(boolean caseInsensitive) {
        for (PackageIdentifier pi : this.getPackages()) {
            pi.setCaseInsensitive(caseInsensitive);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": packages = " + this.countPackages();
    }
}

