/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.common.BytesInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BytesOutputStream
extends ByteArrayOutputStream {
    public BytesOutputStream(int initialCapacity) {
        super(initialCapacity);
    }

    public BytesOutputStream() {
        this(32);
    }

    public int position() {
        return this.size();
    }

    public void write(InputStream inputStream) throws IOException {
        int length;
        if (inputStream instanceof BytesInputStream) {
            this.write((BytesInputStream)inputStream);
            return;
        }
        int bufferStep = 500;
        int maxBuffer = 81920;
        byte[] buffer = new byte[2048];
        while ((length = inputStream.read(buffer, 0, buffer.length)) >= 0) {
            this.write(buffer, 0, length);
            if (buffer.length >= maxBuffer) continue;
            buffer = new byte[buffer.length + bufferStep];
        }
        inputStream.close();
    }

    public void write(BytesInputStream bis) throws IOException {
        byte[] bytes = bis.toByteArray();
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public String toString() {
        return "pos = " + this.size();
    }
}

