/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.attribute;

import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.attribute.AttributeBagItem;

public class AttributeBag {
    private final AttributeBagItem[] mBagItems;
    public static final short TYPE_ENUM = 1;
    public static final short TYPE_FLAG = 2;

    public AttributeBag(AttributeBagItem[] bagItems) {
        this.mBagItems = bagItems;
    }

    public boolean contains(AttributeDataFormat valueType) {
        return this.getFormat().contains(valueType);
    }

    public boolean isEqualType(AttributeDataFormat valueType) {
        return this.getFormat().isEqualType(valueType);
    }

    public boolean isCompatible(ValueType valueType) {
        return AttributeDataFormat.contains(this.getFormats(), valueType);
    }

    public EncodeResult encode(String valueString) {
        EncodeResult encodeResult = this.encodeEnumOrFlagValue(valueString);
        if (encodeResult != null) {
            return encodeResult;
        }
        AttributeDataFormat[] formats = this.getFormats();
        if (formats != null && (encodeResult = ValueCoder.encode(valueString, formats)) != null) {
            return encodeResult;
        }
        if (this.isCompatible(ValueType.STRING)) {
            return new EncodeResult(ValueType.STRING, -1);
        }
        if (this.isEnumOrFlag()) {
            return new EncodeResult("Invalid attribute enum/flag/value");
        }
        return new EncodeResult("Incompatible attribute value, expected formats " + AttributeDataFormat.toString(formats));
    }

    public EncodeResult encodeEnumOrFlagValue(String valueString) {
        String[] splitNames;
        if (valueString == null || !this.isEnumOrFlag()) {
            return null;
        }
        EncodeResult encodeResult = ValueCoder.encode(valueString, AttributeDataFormat.INTEGER);
        if (encodeResult != null) {
            return encodeResult;
        }
        int value = 0;
        boolean foundOnce = false;
        for (String name : splitNames = valueString.split("[\\s|]+")) {
            AttributeBagItem item = this.searchByName(name = name.trim());
            if (item == null) {
                if (name.length() == 0) continue;
                return null;
            }
            value |= item.getBagItem().getData();
            foundOnce = true;
        }
        if (!foundOnce) {
            return null;
        }
        ValueType valueType = this.isFlag() ? ValueType.HEX : ValueType.DEC;
        return new EncodeResult(valueType, value);
    }

    public String decodeAttributeValue(int attrValue) {
        AttributeBagItem[] bagItems = this.searchValue(attrValue);
        return AttributeBagItem.toString(bagItems, false);
    }

    public AttributeBagItem searchByName(String entryName) {
        AttributeBagItem[] bagItems;
        for (AttributeBagItem item : bagItems = this.getBagItems()) {
            if (item.isType() || !entryName.equals(item.getNameOrHex())) continue;
            return item;
        }
        return null;
    }

    public AttributeBagItem[] searchValue(int attrValue) {
        if (this.isFlag()) {
            return this.searchFlagValue(attrValue);
        }
        AttributeBagItem item = this.searchEnumValue(attrValue);
        if (item != null) {
            return new AttributeBagItem[]{item};
        }
        return null;
    }

    private AttributeBagItem searchEnumValue(int attrValue) {
        AttributeBagItem[] bagItems;
        for (AttributeBagItem item : bagItems = this.getBagItems()) {
            int data;
            if (item.isType() || attrValue != (data = item.getData())) continue;
            return item;
        }
        return null;
    }

    private AttributeBagItem[] searchFlagValue(int attrValue) {
        AttributeBagItem[] bagItems = this.getBagItems();
        int len = bagItems.length;
        AttributeBagItem[] foundBags = new AttributeBagItem[len];
        for (int i = 0; i < len; ++i) {
            int data;
            AttributeBagItem item = bagItems[i];
            if (item.isType() || (attrValue & (data = item.getData())) != data) continue;
            if (attrValue == data) {
                return new AttributeBagItem[]{item};
            }
            int index = this.indexOf(foundBags, data);
            if (index < 0) continue;
            foundBags[index] = item;
        }
        return this.removeNull(foundBags);
    }

    private int indexOf(AttributeBagItem[] foundFlag, int data) {
        for (int i = 0; i < foundFlag.length; ++i) {
            AttributeBagItem item = foundFlag[i];
            if (item == null) {
                return i;
            }
            int flag = item.getData();
            if (flag == 0) {
                return i;
            }
            if ((flag & data) == data) {
                return -1;
            }
            if ((flag & data) != flag) continue;
            return i;
        }
        return -1;
    }

    private AttributeBagItem[] removeNull(AttributeBagItem[] bagItems) {
        int count = this.countNonNull(bagItems);
        if (count == 0) {
            return null;
        }
        AttributeBagItem[] results = new AttributeBagItem[count];
        int index = 0;
        for (AttributeBagItem item : bagItems) {
            if (item == null) continue;
            results[index] = item;
            ++index;
        }
        return results;
    }

    private int countNonNull(AttributeBagItem[] bagItems) {
        if (bagItems == null) {
            return 0;
        }
        int result = 0;
        int len = bagItems.length;
        for (int i = 0; i < len; ++i) {
            if (bagItems[i] == null) continue;
            ++result;
        }
        return result;
    }

    public AttributeBagItem[] getBagItems() {
        return this.mBagItems;
    }

    public AttributeDataFormat[] getFormats() {
        return this.getFormat().getDataFormats();
    }

    public AttributeBagItem getFormat() {
        AttributeBagItem item = this.find(AttributeType.FORMATS);
        if (item == null) {
            item = this.getBagItems()[0];
        }
        return item;
    }

    public AttributeBagItem find(AttributeType attributeType) {
        for (AttributeBagItem bagItem : this.getBagItems()) {
            if (bagItem.getType() != attributeType) continue;
            return bagItem;
        }
        return null;
    }

    public boolean isEnumOrFlag() {
        return this.isFlag() || this.isEnum();
    }

    public boolean isFlag() {
        return this.getFormat().isFlag();
    }

    public boolean isEnum() {
        return this.getFormat().isEnum();
    }

    public String toString() {
        AttributeBagItem[] bagItems = this.getBagItems();
        StringBuilder builder = new StringBuilder();
        AttributeBagItem format = this.getFormat();
        Entry entry = format.getBagItem().getEntry();
        if (entry != null) {
            builder.append(entry.getSpecString());
        }
        int len = bagItems.length;
        builder.append(", childes=").append(len);
        for (int i = 0; i < len; ++i) {
            AttributeBagItem item = bagItems[i];
            builder.append("\n    [").append(i + 1).append("]  ");
            builder.append(item.toString());
        }
        return builder.toString();
    }

    public static AttributeBag create(Entry entry) {
        if (entry != null) {
            return AttributeBag.create(entry.getResValueMapArray());
        }
        return null;
    }

    public static AttributeBag create(ResValueMapArray resValueMapArray) {
        if (resValueMapArray == null) {
            return null;
        }
        AttributeBagItem[] bagItems = AttributeBagItem.create((ResValueMap[])resValueMapArray.getChildes());
        if (bagItems == null) {
            return null;
        }
        return new AttributeBag(bagItems);
    }

    public static boolean isAttribute(ResTableMapEntry mapEntry) {
        if (mapEntry == null) {
            return false;
        }
        AttributeBagItem[] bagItems = AttributeBagItem.create(mapEntry.listResValueMap());
        return bagItems != null;
    }
}

