/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.xml.XMLUtil;

public abstract class AttributeValue
extends ValueItem {
    public AttributeValue(int bytesLength, int sizeOffset) {
        super(bytesLength, sizeOffset);
    }

    public abstract int getNameResourceID();

    public abstract void setNameResourceID(int var1);

    public abstract String decodePrefix();

    public abstract String decodeName(boolean var1);

    public String decodeName() {
        return this.decodeName(true);
    }

    public ResourceEntry resolveName() {
        return this.resolve(this.getNameResourceID());
    }

    public EncodeResult encodeStyleValue(ResourceEntry nameEntry, String value) {
        return this.encodeStyleValue(false, nameEntry, value);
    }

    public EncodeResult encodeStyleValue(boolean validate, ResourceEntry name, String value) {
        return ValueCoder.encodeAttributeValue(validate, this, name, value);
    }

    public ResourceEntry encodeAttrName(String name) {
        return this.encodeAttrName(XMLUtil.splitPrefix(name), XMLUtil.splitName(name));
    }

    public ResourceEntry encodeAttrName(String prefix, String name) {
        EncodeResult encodeResult;
        if (name == null) {
            return null;
        }
        if (prefix == null) {
            prefix = XMLUtil.splitPrefix(name);
        }
        if ((encodeResult = ValueCoder.encodeUnknownNameId(name = XMLUtil.splitName(name))) != null) {
            this.setName(name, encodeResult.value);
            return new ResourceEntry(this.getPackageBlock(), encodeResult.value);
        }
        if (prefix == null && !this.allowNullPrefixEncode()) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        ResourceEntry resourceEntry = packageBlock.getTableBlock().getAttrResource(packageBlock, prefix, name);
        if (resourceEntry != null) {
            this.setName(name, resourceEntry.getResourceId());
        }
        return resourceEntry;
    }

    public ResourceEntry encodeIdName(String name) {
        return this.encodeIdName(XMLUtil.splitPrefix(name), XMLUtil.splitName(name));
    }

    public ResourceEntry encodeIdName(String prefix, String name) {
        EncodeResult encodeResult;
        if (name == null) {
            return null;
        }
        if (prefix == null) {
            prefix = XMLUtil.splitPrefix(name);
        }
        if ((encodeResult = ValueCoder.encodeUnknownNameId(name = XMLUtil.splitName(name))) != null) {
            this.setName(name, encodeResult.value);
            return new ResourceEntry(this.getPackageBlock(), encodeResult.value);
        }
        if (prefix == null && !this.allowNullPrefixEncode()) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        ResourceEntry resourceEntry = packageBlock.getTableBlock().getIdResource(packageBlock, prefix, name);
        if (resourceEntry != null) {
            this.setName(name, resourceEntry.getResourceId());
        }
        return resourceEntry;
    }

    boolean allowNullPrefixEncode() {
        return false;
    }

    public void setName(String name, int nameId) {
        this.setNameResourceID(nameId);
    }

    @Override
    public String decodeValue() {
        if (AttributeDataFormat.INTEGER.contains(this.getValueType())) {
            String value = this.decodeDataAsAttrFormats();
            if (value == null) {
                value = this.decodeDataAsAttr();
            }
            if (value != null) {
                return value;
            }
        }
        return super.decodeValue();
    }

    private String decodeDataAsAttr() {
        ResourceEntry attr = this.resolveName();
        if (attr != null) {
            return attr.decodeAttributeData(this.getData());
        }
        return null;
    }

    String decodeDataAsAttrFormats() {
        return null;
    }
}

