/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.model.StyleSpanInfo;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JsonStringPoolHelper<T extends StringItem> {
    private final StringPool<T> stringPool;

    JsonStringPoolHelper(StringPool<T> stringPool) {
        this.stringPool = stringPool;
    }

    void loadStyledStrings(JSONArray jsonArray) {
        this.stringPool.getStringsArray().clearChildes();
        this.stringPool.getStyleArray().clearChildes();
        List<StyledString> styledStringList = StyledString.fromJson(jsonArray);
        this.loadText(styledStringList);
        Map<String, Integer> tagIndexMap = this.loadStyleTags(styledStringList);
        this.loadStyles(styledStringList, tagIndexMap);
        this.stringPool.refreshUniqueIdMap();
    }

    private void loadText(List<StyledString> styledStringList) {
        StringArray<T> stringsArray = this.stringPool.getStringsArray();
        int size = styledStringList.size();
        stringsArray.ensureSize(size);
        for (int i = 0; i < size; ++i) {
            StyledString styledString = styledStringList.get(i);
            StringItem item = (StringItem)stringsArray.get(i);
            item.set(styledString.text);
        }
    }

    private Map<String, Integer> loadStyleTags(List<StyledString> styledStringList) {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        ArrayList<String> tagList = new ArrayList<String>(JsonStringPoolHelper.getStyleTags(styledStringList));
        tagList.sort(CompareUtil.STRING_COMPARATOR);
        StringArray<T> stringsArray = this.stringPool.getStringsArray();
        int tagsSize = tagList.size();
        int initialSize = stringsArray.getChildesCount();
        stringsArray.ensureSize(initialSize + tagsSize);
        for (int i = 0; i < tagsSize; ++i) {
            String tag = (String)tagList.get(i);
            StringItem item = (StringItem)stringsArray.get(initialSize + i);
            item.set(tag);
            indexMap.put(tag, item.getIndex());
        }
        return indexMap;
    }

    private void loadStyles(List<StyledString> styledStringList, Map<String, Integer> tagIndexMap) {
        StyleArray styleArray = this.stringPool.getStyleArray();
        int size = styledStringList.size();
        styleArray.ensureSize(size);
        for (int i = 0; i < size; ++i) {
            StyledString ss = styledStringList.get(i);
            StyleItem styleItem = (StyleItem)styleArray.get(i);
            for (StyleSpanInfo spanInfo : ss.spanInfoList) {
                int tagIndex = tagIndexMap.get(spanInfo.getTag());
                styleItem.addStylePiece(tagIndex, spanInfo.getFirst(), spanInfo.getLast());
            }
        }
    }

    private static Set<String> getStyleTags(List<StyledString> styledStringList) {
        HashSet<String> results = new HashSet<String>();
        for (StyledString ss : styledStringList) {
            for (StyleSpanInfo spanInfo : ss.spanInfoList) {
                results.add(spanInfo.getTag());
            }
        }
        return results;
    }

    private static class StyledString {
        final String text;
        final List<StyleSpanInfo> spanInfoList;

        StyledString(String text, List<StyleSpanInfo> spanInfoList) {
            this.text = text;
            this.spanInfoList = spanInfoList;
        }

        public String toString() {
            return this.text;
        }

        static List<StyledString> fromJson(JSONArray jsonArray) {
            int length = jsonArray.length();
            ArrayList<StyledString> results = new ArrayList<StyledString>(length);
            for (int i = 0; i < length; ++i) {
                StyledString styledString = StyledString.fromJson(jsonArray.getJSONObject(i));
                if (styledString == null) continue;
                results.add(styledString);
            }
            return results;
        }

        private static StyledString fromJson(JSONObject jsonObject) {
            if (!jsonObject.has("style")) {
                return null;
            }
            String text = jsonObject.getString("string");
            JSONObject style = jsonObject.getJSONObject("style");
            JSONArray spansArray = style.getJSONArray("spans");
            List<StyleSpanInfo> spanInfoList = StyledString.toSpanInfoList(spansArray);
            return new StyledString(text, spanInfoList);
        }

        private static List<StyleSpanInfo> toSpanInfoList(JSONArray jsonArray) {
            int length = jsonArray.length();
            ArrayList<StyleSpanInfo> results = new ArrayList<StyleSpanInfo>(length);
            for (int i = 0; i < length; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                StyleSpanInfo spanInfo = new StyleSpanInfo(null, 0, 0);
                spanInfo.fromJson(jsonObject);
                results.add(spanInfo);
            }
            return results;
        }
    }
}

