/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.arsc.model.StyleCharPiece;
import com.reandroid.arsc.model.StyleSpanInfo;
import com.reandroid.xml.StyleDocument;
import com.reandroid.xml.StyleElement;
import com.reandroid.xml.StyleNode;

public class StyledStringBuilder {
    private final String text;
    private final StyleSpanInfo[] spanInfoList;

    public StyledStringBuilder(String text, StyleSpanInfo[] spanInfoList) {
        this.text = text;
        this.spanInfoList = spanInfoList;
    }

    public StyleDocument build() {
        StyleCharPiece[] charPieceList = StyleCharPiece.toCharPieceArray(this.text);
        boolean initOk = StyledStringBuilder.initialize(charPieceList, this.spanInfoList);
        if (!initOk) {
            return null;
        }
        StyleDocument document = new StyleDocument();
        StyleNode styleNode = document;
        for (int i = 0; i < charPieceList.length; ++i) {
            StyleCharPiece charPiece = charPieceList[i];
            styleNode = this.buildStarts(styleNode, charPiece);
            styleNode.appendChar(charPiece.mChar);
            styleNode = this.buildEnd(styleNode, charPiece);
        }
        return document;
    }

    private StyleNode buildStarts(StyleNode styleNode, StyleCharPiece charPiece) {
        StyleSpanInfo info = charPiece.getFirst();
        while (info != null) {
            StyleElement styleElement = new StyleElement(info.getName());
            info.serializeAttributes(styleElement);
            styleNode.addStyleNode(styleElement);
            styleNode = styleElement;
            info = charPiece.getFirst();
            styleNode = this.buildEnd(styleNode, charPiece);
        }
        return styleNode;
    }

    private StyleNode buildEnd(StyleNode styleNode, StyleCharPiece charPiece) {
        if (!(styleNode instanceof StyleElement)) {
            return styleNode;
        }
        StyleElement element = (StyleElement)styleNode;
        StyleSpanInfo info = charPiece.getEnd(element.getName());
        while (info != null && (styleNode = element.getParentStyle()) instanceof StyleElement) {
            element = (StyleElement)styleNode;
            info = charPiece.getEnd(element.getName());
        }
        return styleNode;
    }

    private static boolean initialize(StyleCharPiece[] styleCharPieceArray, StyleSpanInfo[] spanInfoList) {
        for (StyleSpanInfo spanInfo : spanInfoList) {
            boolean spanOk;
            if (spanInfo == null || (spanOk = StyledStringBuilder.initialize(styleCharPieceArray, spanInfo))) continue;
            return false;
        }
        return true;
    }

    private static boolean initialize(StyleCharPiece[] styleCharPieceArray, StyleSpanInfo spanInfo) {
        int length = styleCharPieceArray.length;
        int pos = spanInfo.getFirst();
        if (pos < 0 || pos >= length) {
            return false;
        }
        StyleCharPiece styleCharPiece = styleCharPieceArray[pos];
        styleCharPiece.addFirst(spanInfo);
        pos = spanInfo.getLast();
        if (pos < 0 || pos >= length) {
            return false;
        }
        styleCharPiece = styleCharPieceArray[pos];
        styleCharPiece.addEnd(spanInfo);
        return true;
    }
}

