/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerArrayBlock;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItemReference;
import com.reandroid.arsc.item.WeakStringReference;
import com.reandroid.arsc.model.StyleSpanInfo;
import com.reandroid.arsc.model.StyledStringBuilder;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.xml.StyleDocument;
import com.reandroid.xml.StyleElement;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StyleItem
extends IntegerArrayBlock
implements JSONConvert<JSONObject> {
    private List<StyleSpanInfo> mSpanInfoList;
    private final Set<StyleItemReference> mReferences = new HashSet<StyleItemReference>();
    private StyleIndexReference indexReference;
    private StringItem mStringItem;
    private static final int INDEX_STRING_REF = 0;
    private static final int INDEX_CHAR_FIRST = 1;
    private static final int INDEX_CHAR_LAST = 2;
    private static final int INTEGERS_COUNT = 3;
    private static final int END_VALUE = -1;
    public static final String NAME_spans = "spans";

    public StyleDocument build(String text) {
        return new StyledStringBuilder(text, this.getSpanInfoElements()).build();
    }

    public void parse(StyleDocument document) {
        Iterator<StyleElement> iterator = document.getElements();
        while (iterator.hasNext()) {
            this.parse(iterator.next());
        }
    }

    public void parse(StyleElement element) {
        this.addStylePiece(element.getStyleableTag(), element.getStart(), element.getEnd());
        Iterator<StyleElement> iterator = element.getElements();
        while (iterator.hasNext()) {
            this.parse(iterator.next());
        }
    }

    protected void clearStyle() {
        if (this.getParent() == null) {
            return;
        }
        this.setStylePieceCount(0);
        this.mSpanInfoList = null;
    }

    public void onRemoved() {
        this.unLinkIndexReference();
        this.setStylePieceCount(0);
        this.mSpanInfoList = null;
        StyleArray parentArray = this.getParentInstance(StyleArray.class);
        this.setParent(null);
        this.setIndex(-1);
        if (parentArray != null) {
            parentArray.remove(this);
        }
    }

    public void linkIfRequiredInternal() {
        if (this.indexReference == null) {
            this.linkIndexReference();
            this.linkAll();
        }
    }

    public void onDataLoaded() {
        this.linkIndexReference();
        this.linkAll();
    }

    private void setEndValue(int negOne) {
        super.put(this.size() - 1, negOne);
    }

    final Integer getEndValue() {
        return super.get(this.size() - 1);
    }

    final Integer getStringRef(int index) {
        int i = index * 3 + 0;
        return super.get(i);
    }

    final void setStringRef(int index, int val) {
        int i = index * 3 + 0;
        super.put(i, val);
    }

    private void linkAll() {
        int count = this.getStylePieceCount();
        for (int i = 0; i < count; ++i) {
            StringItem stringItem;
            int[] spanInfo = this.getStylePiece(i);
            if (spanInfo == null || (stringItem = this.getStringItem(spanInfo[0])) == null) continue;
            this.link(stringItem, i);
        }
    }

    private void unlinkAll() {
        for (StyleItemReference itemReference : this.mReferences) {
            StringItem stringItem = this.getStringItem(itemReference.get());
            if (stringItem == null) continue;
            stringItem.removeReference(itemReference);
        }
        this.mReferences.clear();
    }

    private void link(StringItem stringItem, int index) {
        if (stringItem == null) {
            return;
        }
        this.unLink(stringItem, index);
        StyleItemReference itemReference = new StyleItemReference(this, index);
        this.mReferences.add(itemReference);
        stringItem.addReference(itemReference);
    }

    private void unLink(int index) {
        Integer ref = this.getStringRef(index);
        if (ref == null) {
            return;
        }
        this.unLink(this.getStringItem(ref), index);
    }

    private void unLink(StringItem stringItem, int index) {
        if (stringItem == null) {
            return;
        }
        StyleItemReference itemReference = new StyleItemReference(this, index);
        if (!this.mReferences.remove(itemReference)) {
            return;
        }
        stringItem.removeReference(itemReference);
    }

    private void linkIndexReference() {
        StringItem stringItem = this.getStringItem(this.getIndex());
        this.unLinkIndexReference(this.mStringItem);
        if (stringItem == null) {
            return;
        }
        StyleIndexReference reference = new StyleIndexReference(this);
        stringItem.addReference(reference);
        this.indexReference = reference;
        this.mStringItem = stringItem;
    }

    private void unLinkIndexReference() {
        this.unLinkIndexReference(this.mStringItem);
    }

    private void unLinkIndexReference(StringItem stringItem) {
        this.mStringItem = null;
        StyleIndexReference reference = this.indexReference;
        if (reference == null) {
            return;
        }
        this.indexReference = null;
        if (stringItem == null) {
            return;
        }
        stringItem.removeReference(reference);
    }

    final Integer getFirstChar(int index) {
        int i = index * 3 + 1;
        return super.get(i);
    }

    final Integer getLastChar(int index) {
        int i = index * 3 + 2;
        return super.get(i);
    }

    public void addStylePiece(String tag, int firstChar, int lastChar) {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null) {
            throw new IllegalArgumentException("Null string pool, must be added to parent StyleArray first");
        }
        Object stringItem = stringPool.getOrCreate(tag);
        this.addStylePiece(((Block)stringItem).getIndex(), firstChar, lastChar);
    }

    public void addStylePiece(int refString, int firstChar, int lastChar) {
        int index = this.getStylePieceCount();
        this.setStylePieceCount(index + 1);
        this.setStylePiece(index, refString, firstChar, lastChar);
    }

    final void setStylePiece(int index, int refString, int firstChar, int lastChar) {
        this.unLink(index);
        int i = index * 3;
        super.put(i + 0, refString);
        super.put(i + 1, firstChar);
        super.put(i + 2, lastChar);
        this.link(this.getStringItem(refString), index);
    }

    final int[] getStylePiece(int index) {
        if (index < 0 || index >= this.getStylePieceCount()) {
            return null;
        }
        int[] result = new int[3];
        int i = index * 3;
        result[0] = super.get(i);
        result[1] = super.get(i + 1);
        result[2] = super.get(i + 2);
        return result;
    }

    final void setStylePiece(int index, int[] three) {
        if (three == null || three.length < 3) {
            return;
        }
        int i = index * 3;
        super.put(i + 0, three[0]);
        super.put(i + 1, three[1]);
        super.put(i + 2, three[2]);
    }

    final int getStylePieceCount() {
        int sz = this.size() - 1;
        if (sz < 0) {
            sz = 0;
        }
        return sz / 3;
    }

    final void setStylePieceCount(int count) {
        int cur;
        if (count < 0) {
            count = 0;
        }
        if (count == (cur = this.getStylePieceCount()) && this.size() != 0) {
            return;
        }
        if (count == 0) {
            this.unlinkAll();
        }
        int max = count * 3 + 1;
        if (count == 0 || this.size() == 0) {
            super.setSize(max);
            this.setEndValue(-1);
            return;
        }
        ArrayList<int[]> copy = new ArrayList<int[]>(this.getIntSpanInfoList());
        Integer end = this.getEndValue();
        if (end == null) {
            end = -1;
        }
        super.setSize(max);
        max = count;
        int copyMax = copy.size();
        if (copyMax > max) {
            copyMax = max;
        }
        for (int i = 0; i < copyMax; ++i) {
            int[] val = (int[])copy.get(i);
            this.setStylePiece(i, val);
        }
        this.setEndValue(end);
    }

    private List<int[]> getIntSpanInfoList() {
        return new AbstractList<int[]>(){

            @Override
            public int[] get(int i) {
                return StyleItem.this.getStylePiece(i);
            }

            @Override
            public int size() {
                return StyleItem.this.getStylePieceCount();
            }
        };
    }

    public StyleSpanInfo[] getSpanInfoElements() {
        int count = this.getStylePieceCount();
        StyleSpanInfo[] results = new StyleSpanInfo[count];
        for (int i = 0; i < count; ++i) {
            int ref = this.getStringRef(i);
            results[i] = new StyleSpanInfo(this.getStringFromPool(ref), this.getFirstChar(i), this.getLastChar(i));
        }
        return results;
    }

    public final List<StyleSpanInfo> getSpanInfoList() {
        if (this.mSpanInfoList != null) {
            return this.mSpanInfoList;
        }
        this.mSpanInfoList = new AbstractList<StyleSpanInfo>(){

            @Override
            public StyleSpanInfo get(int i) {
                int ref = StyleItem.this.getStringRef(i);
                if (ref <= 0) {
                    return null;
                }
                StyleSpanInfo spanInfo = new StyleSpanInfo(StyleItem.this.getStringFromPool(ref), StyleItem.this.getFirstChar(i), StyleItem.this.getLastChar(i));
                if (!spanInfo.isValid()) {
                    return null;
                }
                return spanInfo;
            }

            @Override
            public int size() {
                return StyleItem.this.getStylePieceCount();
            }
        };
        return this.mSpanInfoList;
    }

    private String getStringFromPool(int ref) {
        StringItem stringItem = this.getStringItem(ref);
        if (stringItem != null) {
            return stringItem.get();
        }
        return null;
    }

    private StringItem getStringItem(int ref) {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool != null) {
            return stringPool.get(ref);
        }
        return null;
    }

    private StringPool<?> getStringPool() {
        return this.getParentInstance(StringPool.class);
    }

    public String applyStyle(String text, boolean xml) {
        return this.applyStyle(text, xml, false);
    }

    public String applyStyle(String text, boolean xml, boolean escapeXmlText) {
        if (text == null) {
            return null;
        }
        StyleDocument styleDocument = this.build(text);
        if (styleDocument == null) {
            return text;
        }
        return styleDocument.getText(xml, escapeXmlText);
    }

    @Override
    public void setNull(boolean is_null) {
        if (!is_null) {
            return;
        }
        this.setStylePieceCount(0);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int nextPos = reader.searchNextIntPosition(4, -1);
        if (nextPos < 0) {
            return;
        }
        int len = nextPos - reader.getPosition() + 4;
        super.setBytesLength(len, false);
        byte[] bts = this.getBytesInternal();
        reader.readFully(bts);
        this.onBytesChanged();
    }

    public void addSpanInfo(String tag, int first, int last) {
        int index = this.getStylePieceCount();
        this.setStylePieceCount(index + 1);
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null) {
            throw new IllegalArgumentException("Null string pool, must be added to parent StyleArray first");
        }
        Object stringItem = stringPool.getOrCreate(tag);
        this.setStylePiece(index, ((Block)stringItem).getIndex(), first, last);
    }

    @Override
    public JSONObject toJson() {
        if (this.isNull()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (StyleSpanInfo spanInfo : this.getSpanInfoList()) {
            if (spanInfo == null) continue;
            JSONObject jsonObjectSpan = spanInfo.toJson();
            jsonArray.put(i, jsonObjectSpan);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        jsonObject.put(NAME_spans, jsonArray);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setNull(true);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = json.getJSONArray(NAME_spans);
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            StyleSpanInfo spanInfo = new StyleSpanInfo(null, 0, 0);
            spanInfo.fromJson(jsonObject);
            this.addSpanInfo(spanInfo.getTag(), spanInfo.getFirst(), spanInfo.getLast());
        }
    }

    public void merge(StyleItem styleItem) {
        if (styleItem == null || styleItem == this) {
            return;
        }
        for (int[] info : styleItem.getIntSpanInfoList()) {
            this.addStylePiece(info[0], info[1], info[2]);
        }
    }

    @Override
    public String toString() {
        return "Spans count = " + this.getSpanInfoList().size();
    }

    static final class StyleIndexReference
    implements WeakStringReference {
        private final StyleItem styleItem;

        StyleIndexReference(StyleItem styleItem) {
            this.styleItem = styleItem;
        }

        @Override
        public void set(int val) {
            StyleArray styleArray = this.styleItem.getParentInstance(StyleArray.class);
            if (styleArray != null) {
                styleArray.setItem(this.styleItem.getIndex(), null);
                styleArray.setItem(val, this.styleItem);
            }
        }

        @Override
        public int get() {
            return this.styleItem.getIndex();
        }

        @Override
        public <T1 extends Block> T1 getReferredParent(Class<T1> parentClass) {
            if (parentClass.isInstance(this.styleItem)) {
                return (T1)this.styleItem;
            }
            return null;
        }
    }
}

