/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.BlockItem;
import com.reandroid.common.IntegerArray;

public class ShortArrayBlock
extends BlockItem
implements IntegerArray {
    public ShortArrayBlock() {
        super(0);
    }

    public boolean contains(int value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (value != this.get(i)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.setSize(0);
    }

    public void add(int value) {
        int current = this.size();
        this.setSize(current + 1);
        this.put(current, value);
    }

    public void add(IntegerArray integerArray) {
        if (IntegerArray.isEmpty(integerArray)) {
            return;
        }
        int old = this.size();
        int size = old + integerArray.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.put(old + i, integerArray.get(i));
        }
    }

    public void add(int[] values) {
        if (IntegerArray.isEmpty(values)) {
            return;
        }
        int old = this.size();
        int size = old + values.length;
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.put(old + i, values[i]);
        }
    }

    public void set(int[] values) {
        if (IntegerArray.isEmpty(values)) {
            this.setSize(0);
            return;
        }
        int size = values.length;
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.put(i, values[i]);
        }
    }

    public int[] toArray() {
        return IntegerArray.toArray(this);
    }

    public void fill(int value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.put(i, value);
        }
    }

    public void ensureArraySize(int size) {
        int current = this.size();
        if (current >= size) {
            return;
        }
        this.setSize(size);
    }

    @Override
    public void setSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.setBytesLength(size * 2);
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size()) {
            return 0;
        }
        return ShortArrayBlock.getShortUnsigned(this.getBytesInternal(), index * 2);
    }

    @Override
    public int size() {
        return this.getBytesLength() / 2;
    }

    public void put(int index, int value) {
        ShortArrayBlock.putShort(this.getBytesInternal(), index * 2, value);
    }

    public String toString() {
        return IntegerArray.toString(this);
    }
}

