/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.utils.StringsUtil;
import java.nio.charset.StandardCharsets;

public class FixedLengthString
extends StringItem {
    private final int bytesLength;

    public FixedLengthString(int bytesLength) {
        super(true);
        this.bytesLength = bytesLength;
        this.setBytesLength(bytesLength);
    }

    @Override
    byte[] encodeString(String str) {
        if (str == null) {
            return new byte[this.bytesLength];
        }
        byte[] bts = FixedLengthString.getUtf16Bytes(str);
        byte[] results = new byte[this.bytesLength];
        int len = bts.length;
        if (len > this.bytesLength) {
            len = this.bytesLength;
        }
        System.arraycopy(bts, 0, results, 0, len);
        return results;
    }

    @Override
    String decodeString() {
        return FixedLengthString.decodeUtf16Bytes(this.getBytesInternal());
    }

    @Override
    public StyleItem getStyle() {
        return null;
    }

    @Override
    int calculateReadLength(BlockReader reader) {
        return this.bytesLength;
    }

    @Override
    public int compareTo(StringItem stringItem) {
        if (stringItem == null) {
            return -1;
        }
        return StringsUtil.compareStrings(this.get(), stringItem.get());
    }

    @Override
    public String toString() {
        return "FIXED-" + this.bytesLength + " {" + this.get() + "}";
    }

    private static String decodeUtf16Bytes(byte[] bts) {
        if (FixedLengthString.isNullBytes(bts)) {
            return null;
        }
        int len = FixedLengthString.getEndNullPosition(bts);
        return new String(bts, 0, len, StandardCharsets.UTF_16LE);
    }

    private static int getEndNullPosition(byte[] bts) {
        int max = bts.length;
        int result = 0;
        boolean found = false;
        for (int i = 1; i < max; ++i) {
            byte b0 = bts[i - 1];
            byte b1 = bts[i];
            if (b0 == 0 && b1 == 0) {
                if (!found) {
                    result = i;
                    found = true;
                    continue;
                }
                if (result >= i - 1) continue;
                return result;
            }
            found = false;
        }
        if (!found) {
            return max;
        }
        return result;
    }
}

