/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.utils.HexUtil;
import java.util.Arrays;

public class AlignItem
extends BlockItem {
    private byte fill;
    private int alignment = 4;
    private static final int ALIGNMENT = 4;

    public AlignItem() {
        super(0);
    }

    public void align(Block block) {
        this.clear();
        this.align(block.countBytes());
    }

    public void align(int count) {
        int alignment = this.getAlignment();
        if (alignment <= 0) {
            return;
        }
        int size = (alignment - count % alignment) % alignment;
        this.setSize(size);
    }

    public void clear() {
        this.setBytesLength(0, false);
    }

    public int size() {
        return this.countBytes();
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        this.setBytesLength(size, false);
        this.setFill(this.fill);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        if (alignment <= 0) {
            this.setBytesLength(0, false);
        }
    }

    public void setFill(byte fill) {
        this.fill = fill;
        byte[] bytes = this.getBytesInternal();
        Arrays.fill(bytes, fill);
    }

    public String toString() {
        int alignment = this.getAlignment();
        if (alignment <= 0) {
            return "OFF";
        }
        int size = this.size();
        byte fill = this.fill;
        StringBuilder builder = new StringBuilder();
        if (alignment != 4) {
            builder.append("alignment=");
            builder.append(alignment);
            builder.append(", ");
        }
        if (fill != 0) {
            builder.append("fill=");
            builder.append(HexUtil.toHex2(fill));
            builder.append(", ");
        }
        builder.append("size=");
        builder.append(size);
        return builder.toString();
    }
}

