/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.ComplexUnit;
import com.reandroid.arsc.value.ValueType;

public class UnitDimension
extends ComplexUnit {
    public static final UnitDimension PX = new UnitDimension(0, "px");
    public static final UnitDimension DP = new UnitDimension(1, "dp");
    public static final UnitDimension DIP = new UnitDimension(1, "dip");
    public static final UnitDimension SP = new UnitDimension(2, "sp");
    public static final UnitDimension PT = new UnitDimension(3, "pt");
    public static final UnitDimension IN = new UnitDimension(4, "in");
    public static final UnitDimension MM = new UnitDimension(5, "mm");
    private static final UnitDimension[] VALUES = new UnitDimension[]{PX, DP, DIP, SP, PT, IN, MM};

    private UnitDimension(int flag, String symbol) {
        super(flag, symbol);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.DIMENSION;
    }

    public static UnitDimension[] values() {
        return (UnitDimension[])VALUES.clone();
    }

    public static UnitDimension valueOf(int flag) {
        for (UnitDimension unit : VALUES) {
            if (flag != unit.getFlag()) continue;
            return unit;
        }
        return null;
    }

    public static UnitDimension valueOf(String symbol) {
        if (symbol == null) {
            return null;
        }
        symbol = symbol.toLowerCase();
        for (UnitDimension unit : VALUES) {
            if (!symbol.equals(unit.getSymbol())) continue;
            return unit;
        }
        return null;
    }

    public static UnitDimension fromPostfix(String text) {
        for (UnitDimension unit : VALUES) {
            if (!unit.hasPostfix(text)) continue;
            return unit;
        }
        return null;
    }
}

