/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.HexUtil;

public class CoderUnknownStringRef
extends Coder {
    public static final CoderUnknownStringRef INS = new CoderUnknownStringRef();
    private static final char PREFIX_CHAR = 's';
    private static final String PREFIX = "string-reference@0x";
    private static final int LENGTH = "string-reference@0x".length() + 8;

    @Override
    public EncodeResult encode(String text) {
        if (text == null || text.length() != LENGTH) {
            return null;
        }
        String prefix = PREFIX;
        if (!text.startsWith(prefix)) {
            return null;
        }
        Integer value = CoderUnknownStringRef.parseHex(text.substring(prefix.length() + 1));
        if (value != null) {
            return new EncodeResult(ValueType.STRING, value);
        }
        return null;
    }

    @Override
    public String decode(int data) {
        return HexUtil.toHex8(PREFIX, data);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.STRING;
    }

    @Override
    boolean canStartWith(char first) {
        return first == 's';
    }
}

