/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.EncodeResult;

public abstract class CoderColor
extends Coder {
    private final int decodedStringLength;

    CoderColor(int decodedStringLength) {
        this.decodedStringLength = decodedStringLength;
    }

    @Override
    public EncodeResult encode(String text) {
        if (text.length() != this.decodedStringLength) {
            return null;
        }
        int[] hexValues = CoderColor.hexToIntegers(text);
        if (hexValues == null) {
            return null;
        }
        return new EncodeResult(this.getValueType(), this.encode(hexValues));
    }

    private int encode(int[] hexValues) {
        int start = hexValues.length - 1;
        boolean compact = start < 6;
        boolean has_alpha = start % 4 == 0;
        int result = has_alpha ? 0 : -16777216;
        int shift = 0;
        for (int i = start; i >= 0; --i) {
            int value = hexValues[i];
            result |= value << shift;
            shift += 4;
            if (!compact) continue;
            result |= value << shift;
            shift += 4;
        }
        return result;
    }

    @Override
    public String decode(int data) {
        StringBuilder builder = new StringBuilder();
        builder.append('#');
        int count = this.decodedStringLength - 2;
        int shiftStep = count < 5 ? 8 : 4;
        for (int shift = shiftStep * count; shift >= 0; shift -= shiftStep) {
            builder.append(CoderColor.byteToHex(data >> shift));
        }
        return builder.toString();
    }

    @Override
    boolean canStartWith(char first) {
        return first == '#';
    }

    private static int[] hexToIntegers(String hexColor) {
        char[] chars = (hexColor = hexColor.toUpperCase()).toCharArray();
        if (chars[0] != '#') {
            return null;
        }
        int length = chars.length;
        int[] result = new int[length];
        for (int i = 1; i < length; ++i) {
            int value;
            char ch = chars[i];
            if (ch >= '0' && ch <= '9') {
                value = ch - 48;
            } else if (ch >= 'A' && ch <= 'F') {
                value = 10 + (ch - 65);
            } else {
                return null;
            }
            result[i] = value;
        }
        return result;
    }

    private static char byteToHex(int i) {
        if ((i &= 0xF) < 10) {
            return (char)(48 + i);
        }
        return (char)(97 + (i -= 10));
    }
}

