/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.array.ResXmlIDArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResIdBuilder
implements Comparator<Integer> {
    private final Map<Integer, String> mIdNameMap = new HashMap<Integer, String>();

    public void buildTo(ResXmlIDMap resXmlIDMap) {
        ResXmlStringPool stringPool = resXmlIDMap.getXmlStringPool();
        StringArray<ResXmlString> xmlStringsArray = stringPool.getStringsArray();
        ResXmlIDArray xmlIDArray = resXmlIDMap.getResXmlIDArray();
        List<Integer> idList = this.getSortedIds();
        int size = idList.size();
        xmlStringsArray.ensureSize(size);
        xmlIDArray.ensureSize(size);
        for (int i = 0; i < size; ++i) {
            ResXmlID xmlID;
            ResXmlString xmlString = (ResXmlString)xmlStringsArray.get(i);
            if (xmlString.hasReference()) {
                ResXmlString replaceXmlString = new ResXmlString(xmlString.isUtf8(), xmlString.get());
                xmlStringsArray.setItem(i, replaceXmlString);
                xmlStringsArray.add(xmlString);
                xmlString = replaceXmlString;
            }
            if ((xmlID = (ResXmlID)xmlIDArray.get(i)).hasReference()) {
                ResXmlID replaceXmlId = new ResXmlID(xmlID.get());
                xmlIDArray.setItem(i, replaceXmlId);
                xmlIDArray.add(xmlID);
                xmlID = replaceXmlId;
            }
            int resourceId = idList.get(i);
            String name = this.mIdNameMap.get(resourceId);
            xmlID.set(resourceId);
            xmlString.set(name);
        }
    }

    public void add(int id, String name) {
        if (id == 0) {
            return;
        }
        if (name == null) {
            name = "";
        }
        this.mIdNameMap.put(id, name);
    }

    private List<Integer> getSortedIds() {
        ArrayList<Integer> results = new ArrayList<Integer>(this.mIdNameMap.keySet());
        results.sort(this);
        return results;
    }

    @Override
    public int compare(Integer i1, Integer i2) {
        return i1.compareTo(i2);
    }
}

