/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.ValueType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class AndroidManifestBlock
extends ResXmlDocument {
    private int mGuessedPackageId;
    public static final String TAG_action = "action";
    public static final String TAG_activity = "activity";
    public static final String TAG_activity_alias = "activity-alias";
    public static final String TAG_application = "application";
    public static final String TAG_category = "category";
    public static final String TAG_data = "data";
    public static final String TAG_intent_filter = "intent-filter";
    public static final String TAG_manifest = "manifest";
    public static final String TAG_meta_data = "meta-data";
    public static final String TAG_package = "package";
    public static final String TAG_permission = "permission";
    public static final String TAG_provider = "provider";
    public static final String TAG_receiver = "receiver";
    public static final String TAG_service = "service";
    public static final String TAG_uses_feature = "uses-feature";
    public static final String TAG_uses_library = "uses-library";
    public static final String TAG_uses_permission = "uses-permission";
    public static final String TAG_uses_sdk = "uses-sdk";
    public static final String NAME_compileSdkVersion = "compileSdkVersion";
    public static final String NAME_compileSdkVersionCodename = "compileSdkVersionCodename";
    public static final String NAME_installLocation = "installLocation";
    public static final String NAME_PACKAGE = "package";
    public static final String NAME_split = "split";
    public static final String NAME_coreApp = "coreApp";
    public static final String NAME_platformBuildVersionCode = "platformBuildVersionCode";
    public static final String NAME_platformBuildVersionName = "platformBuildVersionName";
    public static final String NAME_versionCode = "versionCode";
    public static final String NAME_versionName = "versionName";
    public static final String NAME_minSdkVersion = "minSdkVersion";
    public static final String NAME_targetSdkVersion = "targetSdkVersion";
    public static final String NAME_name = "name";
    public static final String NAME_extractNativeLibs = "extractNativeLibs";
    public static final String NAME_isSplitRequired = "isSplitRequired";
    public static final String NAME_value = "value";
    public static final String NAME_resource = "resource";
    public static final String NAME_debuggable = "debuggable";
    public static final String NAME_icon = "icon";
    public static final String NAME_label = "label";
    public static final String NAME_theme = "theme";
    public static final String NAME_id = "id";
    public static final int ID_name = 0x1010003;
    public static final int ID_compileSdkVersion = 16844146;
    public static final int ID_minSdkVersion = 16843276;
    public static final int ID_targetSdkVersion = 16843376;
    public static final int ID_compileSdkVersionCodename = 16844147;
    public static final int ID_authorities = 0x1010018;
    public static final int ID_host = 16842792;
    public static final int ID_configChanges = 0x101001F;
    public static final int ID_screenOrientation = 0x101001E;
    public static final int ID_extractNativeLibs = 16844010;
    public static final int ID_isSplitRequired = 16844177;
    public static final int ID_value = 16842788;
    public static final int ID_resource = 16842789;
    public static final int ID_versionCode = 16843291;
    public static final int ID_versionName = 16843292;
    public static final int ID_debuggable = 0x101000F;
    public static final int ID_icon = 0x1010002;
    public static final int ID_label = 0x1010001;
    public static final int ID_theme = 0x1010000;
    public static final int ID_id = 0x10100D0;
    public static final String VALUE_android_intent_action_MAIN = "android.intent.action.MAIN";
    public static final String FILE_NAME = "AndroidManifest.xml";
    public static final String FILE_NAME_BIN = "AndroidManifest.xml.bin";
    public static final String FILE_NAME_JSON = "AndroidManifest.xml.json";

    public AndroidManifestBlock() {
        super.getStringPool().setUtf8(false);
    }

    public ApkFile.ApkType guessApkType() {
        if (this.isSplit()) {
            return ApkFile.ApkType.SPLIT;
        }
        Boolean core = this.isCoreApp();
        if (core != null && core.booleanValue()) {
            return ApkFile.ApkType.CORE;
        }
        if (this.getMainActivity() != null) {
            return ApkFile.ApkType.BASE;
        }
        return null;
    }

    public Boolean isCoreApp() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_coreApp);
        if (attribute == null) {
            return null;
        }
        if (attribute.getValueType() != ValueType.BOOLEAN) {
            return null;
        }
        return attribute.getValueAsBoolean();
    }

    public boolean isSplit() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return false;
        }
        return manifest.searchAttributeByName(NAME_split) != null;
    }

    public String getSplit() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_split);
        if (attribute != null) {
            return attribute.getValueAsString();
        }
        return null;
    }

    public void setSplit(String split, boolean forceCreate) {
        ResXmlAttribute attribute;
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return;
        }
        if (forceCreate) {
            attribute = manifest.getOrCreateAttribute(NAME_split, 0);
        } else {
            attribute = manifest.searchAttributeByName(NAME_split);
            if (attribute == null) {
                return;
            }
        }
        attribute.setValueAsString(split);
    }

    public int guessCurrentPackageId() {
        if (this.mGuessedPackageId == 0) {
            this.mGuessedPackageId = this.getIconResourceId() >> 24 & 0xFF;
        }
        return this.mGuessedPackageId;
    }

    @Override
    PackageBlock selectPackageBlock(TableBlock tableBlock) {
        ResourceEntry resourceEntry = tableBlock.getResource(this.getIconResourceId());
        if (resourceEntry == null) {
            return super.selectPackageBlock(tableBlock);
        }
        PackageBlock packageBlock = resourceEntry.getPackageBlock();
        if (packageBlock.getTableBlock() != tableBlock) {
            return super.selectPackageBlock(tableBlock);
        }
        return packageBlock;
    }

    public int getIconResourceId() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return 0;
        }
        ResXmlAttribute iconAttribute = applicationElement.searchAttributeByResourceId(0x1010002);
        if (iconAttribute == null || iconAttribute.getValueType() != ValueType.REFERENCE) {
            return 0;
        }
        return iconAttribute.getData();
    }

    public void setIconResourceId(int resourceId) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute iconAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_icon, 0x1010002);
        iconAttribute.setTypeAndData(ValueType.REFERENCE, resourceId);
    }

    public Integer getApplicationLabelReference() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return null;
        }
        ResXmlAttribute labelAttribute = applicationElement.searchAttributeByResourceId(0x1010001);
        if (labelAttribute == null || labelAttribute.getValueType() != ValueType.REFERENCE) {
            return null;
        }
        return labelAttribute.getData();
    }

    public void setApplicationLabel(int resourceId) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute labelAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_label, 0x1010001);
        labelAttribute.setTypeAndData(ValueType.REFERENCE, resourceId);
    }

    public String getApplicationLabelString() {
        ResXmlElement applicationElement = this.getApplicationElement();
        if (applicationElement == null) {
            return null;
        }
        ResXmlAttribute labelAttribute = applicationElement.searchAttributeByResourceId(0x1010001);
        if (labelAttribute == null || labelAttribute.getValueType() != ValueType.STRING) {
            return null;
        }
        return labelAttribute.getValueAsString();
    }

    public void setApplicationLabel(String label) {
        ResXmlElement applicationElement = this.getOrCreateApplicationElement();
        ResXmlAttribute labelAttribute = applicationElement.getOrCreateAndroidAttribute(NAME_label, 0x1010001);
        labelAttribute.setValueAsString(label);
    }

    public boolean isDebuggable() {
        ResXmlElement application = this.getApplicationElement();
        if (application == null) {
            return false;
        }
        ResXmlAttribute attribute = application.searchAttributeByResourceId(0x101000F);
        if (attribute == null) {
            return false;
        }
        return attribute.getValueAsBoolean();
    }

    public void setDebuggable(boolean debuggable) {
        ResXmlElement application = this.getApplicationElement();
        if (application == null) {
            return;
        }
        ResXmlAttribute attribute = application.searchAttributeByResourceId(0x101000F);
        if (debuggable) {
            if (attribute == null) {
                attribute = application.createAndroidAttribute(NAME_debuggable, 0x101000F);
            }
            attribute.setValueAsBoolean(true);
        } else if (attribute != null) {
            application.removeAttribute(attribute);
        }
    }

    public ResXmlElement getMainActivity() {
        for (ResXmlElement activity : this.listActivities()) {
            for (ResXmlElement intentFilter : activity.listElements(TAG_intent_filter)) {
                for (ResXmlElement action : intentFilter.listElements(TAG_action)) {
                    ResXmlAttribute attribute = action.searchAttributeByResourceId(0x1010003);
                    if (attribute == null || !VALUE_android_intent_action_MAIN.equals(attribute.getValueAsString())) continue;
                    return activity;
                }
            }
        }
        return null;
    }

    public ResXmlElement getOrCreateMainActivity(String name) {
        ResXmlElement activity = this.getMainActivity();
        if (activity == null) {
            ResXmlElement application = this.getOrCreateApplicationElement();
            activity = application.createChildElement(TAG_activity);
            ResXmlElement intentFilter = activity.createChildElement(TAG_intent_filter);
            ResXmlElement action = intentFilter.createChildElement(TAG_action);
            ResXmlAttribute attribute = action.getOrCreateAndroidAttribute(NAME_name, 0x1010003);
            attribute.setValueAsString(VALUE_android_intent_action_MAIN);
            ResXmlElement category = intentFilter.createChildElement(TAG_category);
            attribute = category.getOrCreateAndroidAttribute(NAME_name, 0x1010003);
            attribute.setValueAsString("android.intent.category.DEFAULT");
            category = intentFilter.createChildElement(TAG_category);
            attribute = category.getOrCreateAndroidAttribute(NAME_name, 0x1010003);
            attribute.setValueAsString("android.intent.category.LAUNCHER");
        }
        ResXmlAttribute attribute = activity.getOrCreateAndroidAttribute(NAME_name, 0x1010003);
        attribute.setValueAsString(name);
        return activity;
    }

    public ResXmlElement getOrCreateActivity(String name, boolean activityAlias) {
        ResXmlElement activity = this.getActivity(name, activityAlias);
        if (activity == null) {
            ResXmlElement application = this.getOrCreateApplicationElement();
            activity = application.createChildElement(activityAlias ? TAG_activity_alias : TAG_activity);
            ResXmlAttribute attribute = activity.createAndroidAttribute(NAME_name, 0x1010003);
            attribute.setValueAsString(name);
        }
        return activity;
    }

    public ResXmlElement getActivity(String name, boolean activityAlias) {
        name = this.fullClassName(name);
        for (ResXmlElement element : this.listActivities(activityAlias)) {
            ResXmlAttribute attribute = element.searchAttributeByResourceId(0x1010003);
            if (attribute == null || !name.equals(this.fullClassName(attribute.getValueAsString()))) continue;
            return element;
        }
        return null;
    }

    public List<ResXmlElement> listActivities() {
        return this.listActivities(true);
    }

    public List<ResXmlElement> listActivities(boolean includeActivityAlias) {
        ResXmlElement application = this.getApplicationElement();
        if (application == null) {
            return new ArrayList<ResXmlElement>();
        }
        List<ResXmlElement> results = application.listElements(TAG_activity);
        if (includeActivityAlias && !results.isEmpty()) {
            results.addAll(application.listElements(TAG_activity_alias));
        }
        return results;
    }

    public List<ResXmlElement> listApplicationElementsByTag(String tag) {
        ResXmlElement application = this.getApplicationElement();
        if (application == null) {
            return new ArrayList<ResXmlElement>();
        }
        return application.listElements(tag);
    }

    public List<String> getUsesPermissions() {
        ArrayList<String> results = new ArrayList<String>();
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return results;
        }
        List<ResXmlElement> permissionList = manifestElement.listElements(TAG_uses_permission);
        for (ResXmlElement permission : permissionList) {
            String val;
            ResXmlAttribute nameAttr = permission.searchAttributeByResourceId(0x1010003);
            if (nameAttr == null || nameAttr.getValueType() != ValueType.STRING || (val = nameAttr.getValueAsString()) == null) continue;
            results.add(val);
        }
        return results;
    }

    public ResXmlElement getUsesPermission(String permissionName) {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        List<ResXmlElement> permissionList = manifestElement.listElements(TAG_uses_permission);
        for (ResXmlElement permission : permissionList) {
            String val;
            ResXmlAttribute nameAttr = permission.searchAttributeByResourceId(0x1010003);
            if (nameAttr == null || nameAttr.getValueType() != ValueType.STRING || (val = nameAttr.getValueAsString()) == null || !val.equals(permissionName)) continue;
            return permission;
        }
        return null;
    }

    public ResXmlElement addUsesPermission(String permissionName) {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        ResXmlElement exist = this.getUsesPermission(permissionName);
        if (exist != null) {
            return exist;
        }
        int i = manifestElement.lastIndexOf(TAG_uses_permission);
        ResXmlElement result = manifestElement.createChildElement(TAG_uses_permission);
        ResXmlAttribute attr = result.getOrCreateAndroidAttribute(NAME_name, 0x1010003);
        attr.setValueAsString(permissionName);
        manifestElement.changeIndex(result, ++i);
        return result;
    }

    public String getPackageName() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName("package");
        if (attribute == null || attribute.getValueType() != ValueType.STRING) {
            return null;
        }
        return attribute.getValueAsString();
    }

    public void setPackageName(String packageName) {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlAttribute attribute = manifestElement.getOrCreateAttribute("package", 0);
        if (attribute == null) {
            return;
        }
        attribute.setValueAsString(packageName);
    }

    public Integer getPlatformBuildVersionCode() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_platformBuildVersionCode);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    public void setPlatformBuildVersionCode(int buildVersionCode) {
        this.setManifestAttributeInt(NAME_platformBuildVersionCode, 0, buildVersionCode);
    }

    public String getPlatformBuildVersionName() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByName(NAME_platformBuildVersionName);
        if (attribute == null) {
            return null;
        }
        return attribute.getValueAsString();
    }

    public void setPlatformBuildVersionName(String buildVersionName) {
        this.setManifestAttributeString(NAME_platformBuildVersionName, 0, buildVersionName);
    }

    public Integer getMinSdkVersion() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlElement usesSdk = manifest.getElementByTagName(TAG_uses_sdk);
        if (usesSdk == null) {
            return null;
        }
        ResXmlAttribute attribute = usesSdk.searchAttributeByResourceId(16843276);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    public Integer getTargetSdkVersion() {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlElement usesSdk = manifest.getElementByTagName(TAG_uses_sdk);
        if (usesSdk == null) {
            return null;
        }
        ResXmlAttribute attribute = usesSdk.searchAttributeByResourceId(16843376);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    public Integer getCompileSdkVersion() {
        return this.getManifestAttributeInt(16844146);
    }

    public void setCompileSdkVersion(int val) {
        this.setManifestAttributeInt(NAME_compileSdkVersion, 16844146, val);
    }

    public String getCompileSdkVersionCodename() {
        return this.getManifestAttributeString(16844147);
    }

    public void setCompileSdkVersionCodename(String versionCodeName) {
        this.setManifestAttributeString(NAME_compileSdkVersionCodename, 16844147, versionCodeName);
    }

    public Integer getVersionCode() {
        return this.getManifestAttributeInt(16843291);
    }

    public void setVersionCode(int versionCode) {
        this.setManifestAttributeInt(NAME_versionCode, 16843291, versionCode);
    }

    public String getVersionName() {
        return this.getManifestAttributeString(16843292);
    }

    public void setVersionName(String versionName) {
        this.setManifestAttributeString(NAME_versionName, 16843292, versionName);
    }

    private String getManifestAttributeString(int resourceId) {
        ResXmlElement manifest = this.getManifestElement();
        if (manifest == null) {
            return null;
        }
        ResXmlAttribute attribute = manifest.searchAttributeByResourceId(resourceId);
        if (attribute == null || attribute.getValueType() != ValueType.STRING) {
            return null;
        }
        return attribute.getValueAsString();
    }

    private void setManifestAttributeString(String attributeName, int resourceId, String value) {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlAttribute attribute = manifestElement.getOrCreateAndroidAttribute(attributeName, resourceId);
        attribute.setValueAsString(value);
    }

    private void setManifestAttributeInt(String attributeName, int resourceId, int value) {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlAttribute attribute = manifestElement.getOrCreateAndroidAttribute(attributeName, resourceId);
        attribute.setTypeAndData(ValueType.DEC, value);
    }

    private Integer getManifestAttributeInt(int resourceId) {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        ResXmlAttribute attribute = manifestElement.searchAttributeByResourceId(resourceId);
        if (attribute == null || attribute.getValueType() != ValueType.DEC) {
            return null;
        }
        return attribute.getData();
    }

    public ResXmlElement getOrCreateApplicationElement() {
        ResXmlElement manifestElement = this.getOrCreateManifestElement();
        ResXmlElement application = manifestElement.getElementByTagName(TAG_application);
        if (application == null) {
            application = manifestElement.createChildElement(TAG_application);
        }
        return application;
    }

    public ResXmlElement getApplicationElement() {
        ResXmlElement manifestElement = this.getManifestElement();
        if (manifestElement == null) {
            return null;
        }
        return manifestElement.getElementByTagName(TAG_application);
    }

    public ResXmlElement getManifestElement() {
        ResXmlElement manifestElement = this.getResXmlElement();
        if (manifestElement == null) {
            return null;
        }
        if (!manifestElement.equalsName(TAG_manifest)) {
            return null;
        }
        return manifestElement;
    }

    public String fullClassName(String name) {
        if (name == null || !name.startsWith(".")) {
            return name;
        }
        String packageName = this.getPackageName();
        if (packageName == null) {
            return name;
        }
        return packageName + name;
    }

    private ResXmlElement getOrCreateManifestElement() {
        ResXmlElement manifestElement = this.getResXmlElement();
        if (manifestElement == null) {
            manifestElement = this.createRootElement(TAG_manifest);
        }
        if (!TAG_manifest.equals(manifestElement.getName())) {
            manifestElement.setName(TAG_manifest);
        }
        return manifestElement;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("{");
        builder.append("package").append("=").append(this.getPackageName());
        builder.append(", ").append(NAME_versionCode).append("=").append(this.getVersionCode());
        builder.append(", ").append(NAME_versionName).append("=").append(this.getVersionName());
        builder.append(", ").append(NAME_compileSdkVersion).append("=").append(this.getCompileSdkVersion());
        builder.append(", ").append(NAME_compileSdkVersionCodename).append("=").append(this.getCompileSdkVersionCodename());
        List<String> allPermissions = this.getUsesPermissions();
        builder.append(", PERMISSIONS[");
        boolean appendOnce = false;
        for (String permissions : allPermissions) {
            if (appendOnce) {
                builder.append(", ");
            }
            builder.append(permissions);
            appendOnce = true;
        }
        builder.append("]");
        builder.append("}");
        return builder.toString();
    }

    public static boolean isAndroidManifestBlock(ResXmlDocument xmlBlock) {
        if (xmlBlock == null) {
            return false;
        }
        ResXmlElement root = xmlBlock.getResXmlElement();
        if (root == null) {
            return false;
        }
        return TAG_manifest.equals(root.getName());
    }

    public static AndroidManifestBlock load(File file) throws IOException {
        AndroidManifestBlock manifestBlock = new AndroidManifestBlock();
        manifestBlock.readBytes(new BlockReader(file));
        return manifestBlock;
    }

    public static AndroidManifestBlock load(InputStream inputStream) throws IOException {
        AndroidManifestBlock manifestBlock = new AndroidManifestBlock();
        manifestBlock.readBytes(inputStream);
        return manifestBlock;
    }
}

