/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;

public class BlockLocator
extends BlockCounter {
    private final int bytePosition;
    private Block current;

    public BlockLocator(int bytePosition) {
        super(null);
        this.bytePosition = bytePosition;
    }

    @Override
    public void setCurrent(Block current) {
        if (this.FOUND) {
            return;
        }
        this.current = current;
        if (this.getCountValue() >= this.bytePosition) {
            this.FOUND = true;
        }
    }

    public int getBytePosition() {
        return this.bytePosition;
    }

    public Block getResult() {
        if (this.FOUND) {
            return this.current;
        }
        return null;
    }

    @Override
    public String toString() {
        if (!this.FOUND) {
            return this.getCountValue() + "/" + this.bytePosition;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Found at: ").append(this.getCountValue());
        Block current = this.current;
        builder.append(", block = [").append(current).append(']');
        if (current == null) {
            return builder.toString();
        }
        Block parent = current.getParent();
        if (parent != null) {
            builder.append(", parent = [").append(parent).append(']');
        }
        return builder.toString();
    }
}

