/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.base;

import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockLocator;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Block {
    private int mIndex = -1;
    private Block mParent;
    private boolean mNull;
    private BlockLoad mBlockLoad;

    public abstract byte[] getBytes();

    public abstract int countBytes();

    public final int countUpTo(Block block) {
        BlockCounter counter = new BlockCounter(block);
        this.onCountUpTo(counter);
        return counter.getCountValue();
    }

    public final Block locateBlock(int bytePosition) {
        BlockLocator locator = new BlockLocator(bytePosition);
        this.onCountUpTo(locator);
        return locator.getResult();
    }

    public abstract void onCountUpTo(BlockCounter var1);

    public final void readBytes(BlockReader reader) throws IOException {
        this.onReadBytes(reader);
        this.notifyBlockLoad(reader);
    }

    public final void setBlockLoad(BlockLoad blockLoad) {
        this.mBlockLoad = blockLoad;
    }

    public void notifyBlockLoad() throws IOException {
        this.notifyBlockLoad(null);
    }

    private void notifyBlockLoad(BlockReader reader) throws IOException {
        BlockLoad blockLoad = this.mBlockLoad;
        if (blockLoad != null) {
            blockLoad.onBlockLoaded(reader, this);
        }
    }

    protected void onReadBytes(BlockReader reader) throws IOException {
    }

    public final int writeBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        return this.onWriteBytes(stream);
    }

    protected abstract int onWriteBytes(OutputStream var1) throws IOException;

    public boolean isNull() {
        return this.mNull;
    }

    public void setNull(boolean is_null) {
        this.mNull = is_null;
    }

    public final int getIndex() {
        return this.mIndex;
    }

    public final void setIndex(int index) {
        int old = this.mIndex;
        if (index == old) {
            return;
        }
        this.mIndex = index;
        if (old != -1 && index != -1) {
            this.onIndexChanged(old, index);
        }
    }

    public void onIndexChanged(int oldIndex, int newIndex) {
    }

    public final void setParent(Block parent) {
        if (parent == this) {
            return;
        }
        this.mParent = parent;
    }

    public final Block getParent() {
        return this.mParent;
    }

    public final <T> T getParent(Class<T> parentClass) {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getClass() != parentClass) continue;
            return (T)parent;
        }
        return null;
    }

    public final <T> T getParentInstance(Class<T> parentClass) {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            return (T)parent;
        }
        return null;
    }

    public static int getInteger(byte[] bytes, int offset) {
        if (offset + 4 > bytes.length) {
            return 0;
        }
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 24;
    }

    public static short getShort(byte[] bytes, int offset) {
        if (offset + 2 > bytes.length) {
            return 0;
        }
        return (short)(bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8);
    }

    public static int getShortUnsigned(byte[] bytes, int offset) {
        if (offset + 2 > bytes.length) {
            return 0;
        }
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    public static void putInteger(byte[] bytes, int offset, int val) {
        if (offset + 4 > bytes.length) {
            return;
        }
        bytes[offset + 3] = (byte)(val >>> 24 & 0xFF);
        bytes[offset + 2] = (byte)(val >>> 16 & 0xFF);
        bytes[offset + 1] = (byte)(val >>> 8 & 0xFF);
        bytes[offset] = (byte)(val & 0xFF);
    }

    public static void putShort(byte[] bytes, int offset, short val) {
        bytes[offset + 1] = (byte)(val >>> 8 & 0xFF);
        bytes[offset] = (byte)(val & 0xFF);
    }

    public static void putShort(byte[] bytes, int offset, int value) {
        bytes[offset + 1] = (byte)(value >>> 8 & 0xFF);
        bytes[offset] = (byte)(value & 0xFF);
    }

    public static boolean getBit(byte[] bytes, int byteOffset, int bitIndex) {
        return ((bytes[byteOffset] & 0xFF) >> bitIndex & 1) == 1;
    }

    public static void putBit(byte[] bytes, int byteOffset, int bitIndex, boolean bit) {
        int mask = 1 << bitIndex;
        int add = bit ? mask : 0;
        mask = ~mask & 0xFF;
        int value = bytes[byteOffset] & mask | add;
        bytes[byteOffset] = (byte)value;
    }

    public static long getLong(byte[] bytes, int offset) {
        if (offset + 8 > bytes.length) {
            return 0L;
        }
        long result = 0L;
        for (int index = offset + 7; index >= offset; --index) {
            result <<= 8;
            result |= (long)(bytes[index] & 0xFF);
        }
        return result;
    }

    public static void putLong(byte[] bytes, int offset, long value) {
        if (offset + 8 > bytes.length) {
            return;
        }
        int index = offset;
        offset = index + 8;
        while (index < offset) {
            bytes[index] = (byte)(value & 0xFFL);
            value >>>= 8;
            ++index;
        }
    }

    public static byte[] getBytes(byte[] bytes, int offset, int length) {
        if (bytes.length == 0) {
            return new byte[0];
        }
        int available = bytes.length - offset;
        if (available < 0) {
            available = 0;
        }
        if (length > available) {
            length = available;
        }
        byte[] result = new byte[length];
        System.arraycopy(bytes, offset, result, 0, length);
        return result;
    }

    protected static byte[] addBytes(byte[] bytes1, byte[] bytes2) {
        boolean empty2;
        boolean empty1 = bytes1 == null || bytes1.length == 0;
        boolean bl = empty2 = bytes2 == null || bytes2.length == 0;
        if (empty1 && empty2) {
            return null;
        }
        if (empty1) {
            return bytes2;
        }
        if (empty2) {
            return bytes1;
        }
        int length = bytes1.length + bytes2.length;
        byte[] result = new byte[length];
        int start = bytes1.length;
        System.arraycopy(bytes1, 0, result, 0, start);
        System.arraycopy(bytes2, 0, result, start, bytes2.length);
        return result;
    }
}

