/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ResXmlID;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ResXmlIDArray
extends BlockArray<ResXmlID> {
    private final HeaderBlock mHeaderBlock;
    private final Map<Integer, ResXmlID> mResIdMap;
    private boolean mUpdated;

    public ResXmlIDArray(HeaderBlock headerBlock) {
        this.mHeaderBlock = headerBlock;
        this.mResIdMap = new HashMap<Integer, ResXmlID>();
    }

    public void addResourceId(int index, int resId) {
        if (index < 0) {
            return;
        }
        this.ensureSize(index + 1);
        ResXmlID xmlID = (ResXmlID)this.get(index);
        if (xmlID != null) {
            xmlID.set(resId);
        }
    }

    public ResXmlID getOrCreate(int resId) {
        this.updateIdMap();
        ResXmlID xmlID = this.mResIdMap.get(resId);
        if (xmlID != null) {
            return xmlID;
        }
        xmlID = new ResXmlID(resId);
        this.add(xmlID);
        this.mUpdated = true;
        this.mResIdMap.put(resId, xmlID);
        return xmlID;
    }

    public ResXmlID getByResId(int resId) {
        this.updateIdMap();
        return this.mResIdMap.get(resId);
    }

    public void refreshIdMap() {
        this.mUpdated = false;
        this.updateIdMap();
    }

    private void updateIdMap() {
        if (this.mUpdated) {
            return;
        }
        this.mUpdated = true;
        this.mResIdMap.clear();
        ResXmlID[] allChildes = (ResXmlID[])this.getChildes();
        if (allChildes == null || allChildes.length == 0) {
            return;
        }
        for (ResXmlID xmlID : allChildes) {
            this.mResIdMap.put(xmlID.get(), xmlID);
        }
    }

    @Override
    public ResXmlID newInstance() {
        this.mUpdated = false;
        return new ResXmlID();
    }

    public ResXmlID[] newInstance(int len) {
        this.mUpdated = false;
        return new ResXmlID[len];
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int count = this.calculateCountFromHeaderBlock();
        this.setChildesCount(count);
        super.onReadBytes(reader);
        this.updateIdMap();
    }

    private int calculateCountFromHeaderBlock() {
        int count = this.mHeaderBlock.getChunkSize() - this.mHeaderBlock.getHeaderSize();
        return count /= 4;
    }
}

