/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.IntegerReference;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OffsetBlockArray<T extends Block>
extends BlockArray<T>
implements BlockLoad {
    private final OffsetArray mOffsetArray;
    private final IntegerReference mItemStart;
    private final IntegerReference mItemCount;
    private final AlignItem alignItem;

    public OffsetBlockArray(OffsetArray offsets, IntegerReference itemCount, IntegerReference itemStart) {
        this.mOffsetArray = offsets;
        this.mItemCount = itemCount;
        this.mItemStart = itemStart;
        this.alignItem = new AlignItem();
        if (itemCount instanceof Block) {
            ((Block)((Object)itemCount)).setBlockLoad(this);
        }
    }

    OffsetArray getOffsetArray() {
        return this.mOffsetArray;
    }

    protected AlignItem getAlignItem() {
        return this.alignItem;
    }

    @Override
    public void clearChildes() {
        super.clearChildes();
        this.mOffsetArray.clear();
        this.mItemStart.set(0);
        this.mItemCount.set(0);
        this.alignItem.clear();
    }

    @Override
    public int countBytes() {
        int result = super.countBytes();
        int alignSize = this.getAlignItem().countBytes();
        return result + alignSize;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        super.onCountUpTo(counter);
        if (counter.FOUND) {
            return;
        }
        this.getAlignItem().onCountUpTo(counter);
    }

    @Override
    public byte[] getBytes() {
        byte[] results = super.getBytes();
        if (results == null) {
            return null;
        }
        byte[] alignBytes = this.alignItem.getBytes();
        results = OffsetBlockArray.addBytes(results, alignBytes);
        return results;
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        int result = super.onWriteBytes(stream);
        if (result == 0) {
            return 0;
        }
        return result += this.alignItem.writeBytes(stream);
    }

    @Override
    protected void onRefreshed() {
        this.calculateOffsets();
        this.refreshCount();
        this.refreshStart();
        this.refreshAlignment(this.getAlignItem());
    }

    private void calculateOffsets() {
        Block[] childes = this.getChildes();
        int count = 0;
        if (childes != null) {
            count = childes.length;
        }
        OffsetArray offsetArray = this.getOffsetArray();
        offsetArray.setSize(count);
        if (count == 0) {
            return;
        }
        int sum = 0;
        int length = childes.length;
        for (int i = 0; i < length; ++i) {
            int offset;
            Block item = childes[i];
            if (item == null || item.isNull()) {
                offset = -1;
            } else {
                offset = sum;
                sum += item.countBytes();
            }
            offsetArray.setOffset(i, offset);
        }
    }

    public void refreshCountAndStart() {
        this.refreshCount();
        this.refreshStart();
    }

    public void refreshCount() {
        this.mItemCount.set(this.getChildesCount());
    }

    private void refreshStart() {
        int count = this.getChildesCount();
        if (count == 0) {
            this.mItemStart.set(0);
            this.alignItem.clear();
            return;
        }
        Block parent = this.getParent();
        if (parent == null) {
            return;
        }
        int start = parent.countUpTo(this);
        this.mItemStart.set(start);
    }

    void refreshAlignment(BlockReader reader, AlignItem alignItem) throws IOException {
        this.refreshAlignment(alignItem);
    }

    void refreshAlignment(AlignItem alignItem) {
        if (this.getChildesCount() == 0) {
            alignItem.clear();
            return;
        }
        alignItem.align(this);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null || childes.length == 0) {
            return;
        }
        int noEntry = -1;
        int[] offsetArray = this.mOffsetArray.getOffsets();
        int length = childes.length;
        int zeroPosition = this.getZeroPosition();
        reader.seek(zeroPosition);
        int maximumPosition = zeroPosition;
        for (int i = 0; i < length; ++i) {
            Block item = childes[i];
            int offset = offsetArray[i];
            if (offset == noEntry) {
                item.setNull(true);
                continue;
            }
            int itemStart = zeroPosition + offset;
            reader.seek(itemStart);
            item.readBytes(reader);
            int position = reader.getPosition();
            if (position <= maximumPosition) continue;
            maximumPosition = position;
        }
        if (maximumPosition > 0) {
            reader.seek(maximumPosition);
            this.refreshAlignment(reader, this.getAlignItem());
        }
    }

    private int getZeroPosition() {
        int start = this.mItemStart.get();
        if (start < 0) {
            start = 0;
        }
        return start;
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.mItemCount) {
            int count = this.mItemCount.get();
            this.setChildesCount(count);
            this.getOffsetArray().setSize(count);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": count = ");
        int realCount = this.getChildesCount();
        builder.append(realCount);
        int count = this.mItemCount.get();
        if (realCount != count) {
            builder.append(", countValue=");
            builder.append(count);
        }
        builder.append(", start=");
        builder.append(this.mItemStart.get());
        return builder.toString();
    }
}

