/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.OffsetBlockArray;
import com.reandroid.arsc.array.SparseOffsetsArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.Iterator;

public class EntryArray
extends OffsetBlockArray<Entry>
implements JSONConvert<JSONArray> {
    public EntryArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart) {
        super(offsets, itemCount, itemStart);
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            entry.linkTableStringsInternal(tableStringPool);
        }
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            entry.linkSpecStringsInternal(specStringPool);
        }
    }

    public int getHighestEntryId() {
        if (this.isSparse()) {
            return ((SparseOffsetsArray)this.getOffsetArray()).getHighestId();
        }
        return this.getChildesCount() - 1;
    }

    public int getEntryId(int index) {
        OffsetArray offsetArray = this.getOffsetArray();
        if (offsetArray instanceof SparseOffsetsArray) {
            return ((SparseOffsetsArray)offsetArray).getIdx(index);
        }
        return index;
    }

    public int getEntryIndex(int entryId) {
        OffsetArray offsetArray = this.getOffsetArray();
        if (offsetArray instanceof SparseOffsetsArray) {
            return ((SparseOffsetsArray)offsetArray).indexOf(entryId);
        }
        return entryId;
    }

    public boolean isSparse() {
        return super.getOffsetArray() instanceof SparseOffsetsArray;
    }

    public void destroy() {
        for (Entry entry : this.listItems()) {
            if (entry == null) continue;
            entry.setNull(true);
        }
        this.clearChildes();
    }

    public Boolean hasComplexEntry() {
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            if (entry.isComplex()) {
                return true;
            }
            ResValue resValue = entry.getResValue();
            ValueType valueType = resValue.getValueType();
            if (valueType == null || valueType == ValueType.REFERENCE || valueType == ValueType.NULL) continue;
            return false;
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.iterator(true).hasNext();
    }

    public Entry getOrCreate(short entryId) {
        int id = 0xFFFF & entryId;
        Entry entry = this.getEntry(id);
        if (entry != null) {
            return entry;
        }
        boolean sparse = this.isSparse();
        int count = sparse ? this.getChildesCount() + 1 : id + 1;
        this.updateHighestCount(count);
        if (!sparse) {
            this.refreshCount();
            return (Entry)super.get(id);
        }
        SparseOffsetsArray offsetsArray = (SparseOffsetsArray)this.getOffsetArray();
        offsetsArray.ensureArraySize(this.getChildesCount());
        int index = count - 1;
        offsetsArray.setIdx(index, id);
        this.refreshCount();
        return (Entry)super.get(index);
    }

    public Entry get(short entryId) {
        return this.getEntry(entryId);
    }

    public Entry getEntry(short entryId) {
        return this.getEntry(0xFFFF & entryId);
    }

    public Entry getEntry(int entryId) {
        int index = this.getEntryIndex(entryId);
        return (Entry)super.get(index);
    }

    public Entry getEntry(String entryName) {
        if (entryName == null) {
            return null;
        }
        TypeBlock typeBlock = this.getParentInstance(TypeBlock.class);
        if (typeBlock == null) {
            return null;
        }
        PackageBlock packageBlock = typeBlock.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        Iterator<Entry> iterator = packageBlock.getEntries(typeBlock.getTypeName(), entryName);
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.getParentInstance(EntryArray.class) != this) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Entry newInstance() {
        return new Entry();
    }

    public Entry[] newInstance(int len) {
        return new Entry[len];
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        int index = 0;
        String name_id = "id";
        for (Entry entry : this.listItems(true)) {
            JSONObject childObject = entry.toJson();
            if (childObject == null) continue;
            childObject.put(name_id, entry.getId());
            jsonArray.put(index, childObject);
            ++index;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        this.clearChildes();
        if (this.isSparse()) {
            this.fromJsonSparse(json);
        } else {
            this.fromJsonNonSparse(json);
        }
        this.refreshCountAndStart();
    }

    private void fromJsonNonSparse(JSONArray json) {
        int length = json.length();
        this.ensureSize(length);
        String name_id = "id";
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = json.optJSONObject(i);
            if (jsonObject == null) continue;
            int id = jsonObject.getInt(name_id);
            this.ensureSize(id + 1);
            Entry entry = (Entry)super.get(id);
            entry.fromJson(jsonObject);
        }
    }

    private void fromJsonSparse(JSONArray json) {
        SparseOffsetsArray offsetsArray = (SparseOffsetsArray)this.getOffsetArray();
        offsetsArray.setSize(0);
        int length = json.length();
        this.ensureSize(length);
        offsetsArray.setSize(length);
        String name_id = "id";
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = json.optJSONObject(i);
            if (jsonObject == null) {
                offsetsArray.setIdx(i, -1);
                continue;
            }
            int id = jsonObject.getInt(name_id);
            Entry entry = (Entry)super.get(i);
            offsetsArray.setIdx(i, id);
            entry.fromJson(jsonObject);
        }
    }

    public void merge(EntryArray entryArray) {
        if (entryArray == null || entryArray == this || entryArray.isEmpty()) {
            return;
        }
        if (this.isSparse()) {
            this.mergeSparse(entryArray);
        } else {
            this.mergeNonSparse(entryArray);
        }
        this.refreshCountAndStart();
    }

    private void mergeSparse(EntryArray entryArray) {
        Iterator itr = entryArray.iterator(true);
        while (itr.hasNext()) {
            Entry comingBlock = (Entry)itr.next();
            Entry existingBlock = this.getOrCreate((short)comingBlock.getId());
            existingBlock.merge(comingBlock);
        }
    }

    private void mergeNonSparse(EntryArray entryArray) {
        this.ensureSize(entryArray.getChildesCount());
        Iterator itr = entryArray.iterator(true);
        while (itr.hasNext()) {
            Entry comingBlock = (Entry)itr.next();
            Entry existingBlock = (Entry)super.get(comingBlock.getIndex());
            existingBlock.merge(comingBlock);
        }
    }

    private void updateHighestCount(int count) {
        SpecTypePair specTypePair = this.getParentInstance(SpecTypePair.class);
        if (specTypePair == null) {
            this.ensureSize(count);
            return;
        }
        int maxCount = specTypePair.getHighestEntryCount();
        if (count > maxCount) {
            maxCount = count;
        }
        this.ensureSize(maxCount);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": size=" + this.getChildesCount();
    }
}

