/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.writer;

import com.reandroid.apk.APKLogger;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.WriteProgress;
import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.block.EndRecord;
import com.reandroid.archive.block.Zip64Locator;
import com.reandroid.archive.block.Zip64Record;
import com.reandroid.archive.block.ZipHeader;
import com.reandroid.archive.io.ZipOutput;
import com.reandroid.archive.writer.OutputSource;
import com.reandroid.archive.writer.ZipAligner;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ApkWriter<T extends ZipOutput, OUT extends OutputSource>
implements Closeable {
    private final Object mLock = new Object();
    private final T zipOutput;
    private final InputSource[] inputSources;
    private ZipAligner zipAligner;
    private ApkSignatureBlock apkSignatureBlock;
    private APKLogger apkLogger;
    private WriteProgress writeProgress;

    public ApkWriter(T zipOutput, InputSource[] sources) {
        this.zipOutput = zipOutput;
        this.inputSources = sources;
        this.zipAligner = ZipAligner.apkAligner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            OutputSource[] outList = this.buildOutputEntries();
            this.prepareOutputs(outList);
            this.writeApkList(outList);
            this.closeBuffer();
            this.writeSignatureBlock();
            this.writeCEHList(outList);
            this.close();
        }
    }

    private void writeApkList(OUT[] outputList) throws IOException {
        int length = outputList.length;
        this.logMessage("Writing files: " + length);
        APKLogger logger = this.getApkLogger();
        ZipAligner zipAligner = this.getZipAligner();
        for (int i = 0; i < length; ++i) {
            OUT out = outputList[i];
            ((OutputSource)out).setAPKLogger(logger);
            this.writeApk(out, zipAligner);
            if (i % 100 != 0) continue;
            ((OutputSource)out).logFileWrite();
        }
    }

    void closeBuffer() throws IOException {
    }

    private void writeCEHList(OUT[] outputList) throws IOException {
        EndRecord endRecord = new EndRecord();
        endRecord.setSignature(ZipSignature.END_RECORD);
        long offset = this.position();
        endRecord.setOffsetOfCentralDirectory(offset);
        int count = outputList.length;
        endRecord.setNumberOfDirectories(count);
        endRecord.setTotalNumberOfDirectories(count);
        T zipOutput = this.getZipOutput();
        for (int i = 0; i < count; ++i) {
            OUT outputSource = outputList[i];
            ((OutputSource)outputSource).writeCEH((ZipOutput)zipOutput);
        }
        long cedLength = this.position() - offset;
        endRecord.setLengthOfCentralDirectory(cedLength);
        OutputStream outputStream = this.getOutputStream();
        Zip64Record zip64Record = endRecord.getZip64Record();
        if (zip64Record != null) {
            long offsetOfRecord = this.position();
            this.logMessage("ZIP64: " + zip64Record);
            zip64Record.writeBytes(outputStream);
            Zip64Locator zip64Locator = endRecord.getZip64Locator();
            zip64Locator.setOffsetZip64Record(offsetOfRecord);
            this.logMessage("ZIP64: " + zip64Locator);
            zip64Locator.writeBytes(outputStream);
        }
        endRecord.writeBytes(this.getOutputStream());
    }

    OUT[] buildOutputEntries() {
        InputSource[] sources = this.getInputSources();
        int length = sources.length;
        OutputSource[] results = this.createOutArray(length);
        for (int i = 0; i < length; ++i) {
            InputSource inputSource = sources[i];
            results[i] = this.toOutputSource(inputSource);
        }
        return results;
    }

    abstract void writeApk(OUT var1, ZipAligner var2) throws IOException;

    abstract void prepareOutputs(OUT[] var1) throws IOException;

    abstract OUT toOutputSource(InputSource var1);

    abstract OUT[] createOutArray(int var1);

    long position() throws IOException {
        return this.zipOutput.position();
    }

    OutputStream getOutputStream() throws IOException {
        return this.zipOutput.getOutputStream();
    }

    T getZipOutput() {
        return this.zipOutput;
    }

    InputSource[] getInputSources() {
        return this.inputSources;
    }

    public ZipAligner getZipAligner() {
        return this.zipAligner;
    }

    public void setZipAligner(ZipAligner zipAligner) {
        this.zipAligner = zipAligner;
    }

    public void setApkSignatureBlock(ApkSignatureBlock apkSignatureBlock) {
        this.apkSignatureBlock = apkSignatureBlock;
    }

    public ApkSignatureBlock getApkSignatureBlock() {
        return this.apkSignatureBlock;
    }

    void writeSignatureBlock() throws IOException {
        ApkSignatureBlock signatureBlock = this.getApkSignatureBlock();
        if (signatureBlock == null) {
            return;
        }
        this.logMessage("Writing signature block ...");
        long offset = this.position();
        if (ZipHeader.isZip64Length(offset)) {
            this.logMessage("ZIP64 mode, skip writing signature block!");
            return;
        }
        int alignment = 4096;
        int filesPadding = (int)(((long)alignment - offset % (long)alignment) % (long)alignment);
        OutputStream outputStream = this.getOutputStream();
        if (filesPadding > 0) {
            outputStream.write(new byte[filesPadding]);
        }
        signatureBlock.updatePadding();
        signatureBlock.writeBytes(outputStream);
    }

    @Override
    public void close() throws IOException {
        this.zipOutput.close();
    }

    public void setWriteProgress(WriteProgress writeProgress) {
        this.writeProgress = writeProgress;
    }

    void onCompressFileProgress(String path, int mode, long writtenBytes) {
        if (this.writeProgress != null) {
            this.writeProgress.onCompressFile(path, mode, writtenBytes);
        }
    }

    APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }
}

