/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.ZipSignature;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.CommonHeader;
import com.reandroid.archive.block.DataDescriptor;
import java.io.IOException;
import java.io.InputStream;

public class LocalFileHeader
extends CommonHeader {
    private DataDescriptor dataDescriptor;
    private CentralEntryHeader centralEntryHeader;
    private static final int OFFSET_signature = 0;
    private static final int OFFSET_versionMadeBy = 4;
    private static final int OFFSET_platform = 5;
    private static final int OFFSET_general_purpose = 6;
    private static final int OFFSET_method = 8;
    private static final int OFFSET_dos_time = 10;
    private static final int OFFSET_crc = 14;
    private static final int OFFSET_compressed_size = 18;
    private static final int OFFSET_size = 22;
    private static final int OFFSET_fileNameLength = 26;
    private static final int OFFSET_extraLength = 28;
    private static final int OFFSET_fileName = 30;

    public LocalFileHeader() {
        super(30, ZipSignature.LOCAL_FILE, 6);
    }

    public LocalFileHeader(String name) {
        this();
        this.setFileName(name);
    }

    public CentralEntryHeader getCentralEntryHeader() {
        return this.centralEntryHeader;
    }

    public void setCentralEntryHeader(CentralEntryHeader ceh) {
        this.centralEntryHeader = ceh;
        if (ceh == null) {
            return;
        }
        this.mergeZeroValues(ceh);
    }

    public LocalFileHeader copy() {
        LocalFileHeader lfh = new LocalFileHeader();
        lfh.setSignature(ZipSignature.LOCAL_FILE);
        lfh.setFileName(this.getFileName());
        lfh.getGeneralPurposeFlag().setValue(this.getGeneralPurposeFlag().getValue());
        lfh.setCompressedSize(this.getCompressedSize());
        lfh.setSize(this.getSize());
        lfh.setCrc(this.getCrc());
        DataDescriptor dd = this.getDataDescriptor();
        if (dd != null) {
            lfh.setDataDescriptor(dd.copy());
        }
        lfh.setDosTime(this.getDosTime());
        lfh.setPlatform(this.getPlatform());
        lfh.setVersionMadeBy(this.getVersionMadeBy());
        lfh.setMethod(this.getMethod());
        return lfh;
    }

    public void mergeZeroValues(CentralEntryHeader ceh) {
        if (this.getFileOffset() == 0L) {
            this.setFileOffset(ceh.getFileOffset());
        }
        if (this.getCrc() == 0L) {
            this.setCrc(ceh.getCrc());
        }
        if (this.getSize() == 0L) {
            this.setSize(ceh.getSize());
        }
        if (this.getCompressedSize() == 0L) {
            this.setCompressedSize(ceh.getCompressedSize());
        }
        if (this.getGeneralPurposeFlag().getValue() == 0) {
            this.getGeneralPurposeFlag().setValue(ceh.getGeneralPurposeFlag().getValue());
        }
    }

    @Override
    public long getCompressedSize() {
        if (this.isZip64()) {
            return this.getZip64CompressedSize();
        }
        return this.getIntegerUnsigned(this.getOffsetCompressedSize());
    }

    @Override
    public void setCompressedSize(long value) {
        if (this.isZip64Value() || LocalFileHeader.isZip64Value(value)) {
            this.ensureZip64();
            this.putInteger(this.getOffsetCompressedSize(), -1);
            this.setZip64CompressedSize(value);
        } else {
            this.putInteger(this.getOffsetCompressedSize(), value);
        }
    }

    @Override
    public long getSize() {
        if (this.isZip64()) {
            return this.getZip64Size();
        }
        return this.getIntegerUnsigned(this.getOffsetSize());
    }

    @Override
    public void setSize(long value) {
        if (this.isZip64Value() || LocalFileHeader.isZip64Value(value)) {
            this.ensureZip64();
            this.putInteger(this.getOffsetSize(), -1);
            this.setZip64CompressedSize(value);
        } else {
            this.putInteger(this.getOffsetSize(), value);
        }
    }

    public DataDescriptor getDataDescriptor() {
        return this.dataDescriptor;
    }

    public void setDataDescriptor(DataDescriptor dataDescriptor) {
        this.dataDescriptor = dataDescriptor;
        this.getGeneralPurposeFlag().setHasDataDescriptor(dataDescriptor != null);
    }

    public static LocalFileHeader fromCentralEntryHeader(CentralEntryHeader ceh) {
        LocalFileHeader lfh = new LocalFileHeader();
        lfh.setSignature(ZipSignature.LOCAL_FILE);
        lfh.setVersionMadeBy(ceh.getVersionMadeBy());
        lfh.getGeneralPurposeFlag().setValue(ceh.getGeneralPurposeFlag().getValue());
        lfh.setMethod(ceh.getMethod());
        lfh.setDosTime(ceh.getDosTime());
        lfh.setCrc(ceh.getCrc());
        lfh.setCompressedSize(ceh.getCompressedSize());
        lfh.setSize(ceh.getSize());
        lfh.setFileName(ceh.getFileName());
        return lfh;
    }

    public static LocalFileHeader read(InputStream inputStream) throws IOException {
        LocalFileHeader localFileHeader = new LocalFileHeader();
        localFileHeader.readBytes(inputStream);
        if (localFileHeader.isValidSignature()) {
            return localFileHeader;
        }
        return null;
    }
}

