/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.InputSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;

public class ZipEntryMap
implements Comparator<InputSource> {
    private final Object mLock = new Object();
    private final LinkedHashMap<String, InputSource> mSourceMap;
    private InputSource[] sourcesArray;

    public ZipEntryMap(LinkedHashMap<String, InputSource> entriesMap) {
        this.mSourceMap = entriesMap;
    }

    public ZipEntryMap() {
        this(new LinkedHashMap<String, InputSource>());
    }

    public LinkedHashMap<String, InputSource> toAliasMap() {
        InputSource[] sources = this.toArray();
        int length = sources.length;
        LinkedHashMap<String, InputSource> map = new LinkedHashMap<String, InputSource>();
        for (int i = 0; i < length; ++i) {
            InputSource inputSource = sources[i];
            map.put(inputSource.getAlias(), inputSource);
        }
        return map;
    }

    public InputSource[] toArray(boolean sort) {
        InputSource[] sources = this.toArray();
        if (sort) {
            Arrays.sort(sources, this);
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource[] toArray() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.sourcesArray != null) {
                return this.sourcesArray;
            }
            LinkedHashMap<String, InputSource> map = this.mSourceMap;
            InputSource[] sources = new InputSource[map.size()];
            int index = 0;
            Iterator<InputSource> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                InputSource inputSource;
                sources[index] = inputSource = iterator.next();
                ++index;
            }
            this.sourcesArray = sources;
            return sources;
        }
    }

    private void onChanged(boolean changed) {
        if (changed) {
            this.sourcesArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSourceMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDir(String dirName) {
        if (!dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        Object object = this.mLock;
        synchronized (object) {
            boolean changed = false;
            for (InputSource inputSource : this.toArray()) {
                if (!inputSource.getName().startsWith(dirName)) continue;
                inputSource = (InputSource)this.mSourceMap.remove(inputSource.getName());
                if (changed) continue;
                changed = inputSource != null;
            }
            this.onChanged(changed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSourceMap.clear();
            this.onChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Pattern pattern) {
        Object object = this.mLock;
        synchronized (object) {
            boolean removed = false;
            LinkedHashMap<String, InputSource> map = this.mSourceMap;
            for (InputSource inputSource : this.toArray()) {
                String name = inputSource.getAlias();
                if (!pattern.matcher(name).matches() || map.remove(name) == null) continue;
                removed = true;
            }
            this.onChanged(removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource remove(String name) {
        Object object = this.mLock;
        synchronized (object) {
            InputSource inputSource = (InputSource)this.mSourceMap.remove(name);
            this.onChanged(inputSource != null);
            return inputSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(InputSource[] sources) {
        if (sources == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int length = sources.length;
            LinkedHashMap<String, InputSource> map = this.mSourceMap;
            boolean added = false;
            for (int i = 0; i < length; ++i) {
                InputSource inputSource = sources[i];
                if (inputSource == null) continue;
                String name = inputSource.getName();
                map.remove(name);
                map.put(name, inputSource);
                if (!added) {
                    this.onChanged(true);
                }
                added = true;
            }
            this.onChanged(added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InputSource inputSource) {
        if (inputSource == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            String name = inputSource.getName();
            LinkedHashMap<String, InputSource> map = this.mSourceMap;
            map.remove(name);
            map.put(name, inputSource);
            this.onChanged(true);
        }
    }

    public List<InputSource> listInputSources() {
        return new ArrayList<InputSource>(this.mSourceMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource getInputSource(String name) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSourceMap.get(name);
        }
    }

    public void refresh() {
        InputSource[] inputSourceList = this.toArray(true);
        this.set(inputSourceList);
    }

    public void autoSortApkFiles() {
        InputSource inputSource;
        int i;
        InputSource[] sources = this.toArray();
        int length = sources.length;
        for (i = 0; i < length; ++i) {
            inputSource = sources[i];
            inputSource.setSort(-1);
        }
        Arrays.sort(sources, InputSource.ALIAS_COMPARATOR);
        for (i = 0; i < length; ++i) {
            inputSource = sources[i];
            inputSource.setSort(i);
        }
        this.set(sources);
    }

    private void set(InputSource[] sources) {
        this.clear();
        this.addAll(sources);
    }

    @Override
    public int compare(InputSource inputSource1, InputSource inputSource2) {
        if (inputSource1 == inputSource2) {
            return 0;
        }
        if (inputSource1 == null) {
            return 1;
        }
        if (inputSource2 == null) {
            return -1;
        }
        return Integer.compare(inputSource1.getSort(), inputSource2.getSort());
    }
}

