/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.Archive;
import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.io.ArchiveByteEntrySource;
import com.reandroid.archive.io.ZipByteInput;
import com.reandroid.utils.io.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ArchiveBytes
extends Archive<ZipByteInput> {
    public ArchiveBytes(ZipByteInput zipInput) throws IOException {
        super(zipInput);
    }

    public ArchiveBytes(byte[] array) throws IOException {
        super(new ZipByteInput(array));
    }

    public ArchiveBytes(InputStream inputStream) throws IOException {
        this(IOUtil.readFully(inputStream));
    }

    @Override
    InputSource createInputSource(ArchiveEntry entry) {
        return new ArchiveByteEntrySource((ZipByteInput)this.getZipInput(), entry);
    }

    @Override
    void extractStored(File file, ArchiveEntry archiveEntry) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        InputStream inputStream = ((ZipByteInput)this.getZipInput()).getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
        FileOutputStream outputStream = new FileOutputStream(file);
        IOUtil.writeAll(inputStream, outputStream);
        outputStream.close();
        inputStream.close();
    }
}

