/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.UncompressedFiles;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.protect.ProtectorOptions;
import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.FixedLengthString;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.commons.command.ARGException;
import java.io.File;
import java.io.IOException;

public class Protector
extends BaseCommand<ProtectorOptions> {
    public static final String ARG_SHORT = "p";
    public static final String ARG_LONG = "protect";
    public static final String DESCRIPTION = "Protects/Obfuscates apk resource";

    public Protector(ProtectorOptions options) {
        super(options, "[PROTECT] ");
    }

    @Override
    public void run() throws IOException {
        this.logMessage("Loading apk ...");
        ProtectorOptions options = (ProtectorOptions)this.getOptions();
        ApkModule module = ApkModule.loadApkFile(this, options.inputFile, new File[0]);
        module.setLoadDefaultFramework(false);
        String protect = Util.isProtected(module);
        if (protect != null) {
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        this.confuseAndroidManifest(module);
        this.logMessage("Protecting files ..");
        this.confuseResDir(module);
        this.logMessage("Protecting resource table ..");
        this.confuseByteOffset(module);
        this.confuseResourceTable(module);
        Util.addApkEditorInfo(module, "PROTECTED");
        module.getTableBlock().refresh();
        this.logMessage("Writing apk ...");
        module.writeApk(options.outputFile);
        module.close();
        this.logMessage("Saved to: " + options.outputFile);
    }

    private void confuseAndroidManifest(ApkModule apkModule) {
        ProtectorOptions options = (ProtectorOptions)this.getOptions();
        if (options.skipManifest) {
            this.logMessage("Skip AndroidManifest");
            return;
        }
        this.logMessage("Confusing AndroidManifest ...");
        AndroidManifestBlock manifestBlock = apkModule.getAndroidManifestBlock();
        manifestBlock.setAttributesUnitSize(24, true);
        manifestBlock.refresh();
    }

    private void confuseByteOffset(ApkModule apkModule) {
        this.logMessage("METHOD-1 Protecting resource table ..");
        TableBlock tableBlock = apkModule.getTableBlock();
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
                for (ResConfig resConfig : specTypePair.listResConfig()) {
                    resConfig.trimToSize(16);
                }
            }
        }
        tableBlock.refresh();
    }

    private void confuseResourceTable(ApkModule apkModule) {
        this.logMessage("METHOD-2 Protecting resource table ..");
        TableBlock tableBlock = apkModule.getTableBlock();
        UnknownChunk unknownChunk = new UnknownChunk();
        FixedLengthString fixedLengthString = new FixedLengthString(256);
        fixedLengthString.set(APKEditor.getRepo());
        ByteArray extra = ((HeaderBlock)unknownChunk.getHeaderBlock()).getExtraBytes();
        byte[] bts = fixedLengthString.getBytes();
        extra.setSize(bts.length);
        extra.putByteArray(0, bts);
        fixedLengthString.set(BuildInfo.getRepo());
        extra = unknownChunk.getBody();
        bts = fixedLengthString.getBytes();
        extra.setSize(bts.length);
        extra.putByteArray(0, bts);
        fixedLengthString.set(BuildInfo.getRepo());
        unknownChunk.refresh();
        tableBlock.getFirstPlaceHolder().setItem(unknownChunk);
        tableBlock.refresh();
    }

    private void confuseResDir(ApkModule apkModule) {
        this.logMessage("Protecting files ..");
        String[] dirNames = new String[]{"AndroidManifest.xml", "resources.arsc", "classes.dex"};
        UncompressedFiles uf = apkModule.getUncompressedFiles();
        int i = 0;
        for (ResFile resFile : apkModule.listResFiles()) {
            if (i >= dirNames.length) {
                i = 0;
            }
            int method = resFile.getInputSource().getMethod();
            String path = resFile.getFilePath();
            Entry entryBlock = resFile.pickOne();
            if (entryBlock != null && "font".equals(entryBlock.getTypeName())) {
                this.logMessage("  Ignored: " + path);
                continue;
            }
            String pathNew = ApkUtil.replaceRootDir(path, dirNames[i]);
            if (method == 0) {
                uf.replacePath(path, pathNew);
            }
            resFile.setFilePath(pathNew);
            ++i;
        }
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(ProtectorOptions.getHelp());
        }
        ProtectorOptions option = new ProtectorOptions();
        option.parse(args);
        File outFile = option.outputFile;
        Util.deleteEmptyDirectories(outFile);
        Protector protector = new Protector(option);
        if (outFile.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outFile);
            }
            protector.logMessage("Deleting: " + outFile);
            Util.deleteDir(outFile);
        }
        protector.logMessage("Protecting ...\n" + option);
        protector.run();
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

