/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.common;

import com.reandroid.apk.APKLogger;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.EmptyList;
import java.util.List;
import java.util.function.Predicate;

public class AndroidManifestHelper {
    static final Predicate<ResXmlAttribute> NAME_FILTER = attribute -> {
        if (!AndroidManifestHelper.isNameResourceId(attribute)) {
            return false;
        }
        return attribute.getValueType() == ValueType.STRING;
    };

    public static List<ResXmlElement> listSplitRequired(ResXmlElement parentElement) {
        if (parentElement == null) {
            return EmptyList.of();
        }
        return CollectionUtil.toList(parentElement.getElements(element -> {
            if (!element.equalsName("meta-data")) {
                return false;
            }
            ResXmlAttribute nameAttribute = CollectionUtil.getFirst(element.getAttributes(NAME_FILTER));
            if (nameAttribute == null) {
                return false;
            }
            String value = nameAttribute.getValueAsString();
            if (value == null) {
                return false;
            }
            return value.startsWith("com.android.vending.") || value.startsWith("com.android.stamp.");
        }));
    }

    public static void removeAttributeFromManifestAndApplication(AndroidManifestBlock androidManifestBlock, int resourceId, APKLogger logger, String nameForLogging) {
        if (resourceId == 0) {
            return;
        }
        ResXmlElement manifestElement = androidManifestBlock.getManifestElement();
        if (manifestElement == null) {
            if (logger != null) {
                logger.logMessage("WARN: AndroidManifest don't have <manifest>");
            }
            return;
        }
        int removed = manifestElement.removeAttributesWithId(resourceId);
        ResXmlElement applicationElement = manifestElement.getElementByTagName("application");
        if (removed > 1 && logger != null) {
            logger.logMessage("Duplicate attributes on <manifest> removed: " + HexUtil.toHex8("0x", resourceId));
        }
        if (applicationElement == null) {
            return;
        }
        removed = applicationElement.removeAttributesWithId(resourceId);
        if (removed > 1 && logger != null) {
            logger.logMessage("Duplicate attributes on <application> removed: " + HexUtil.toHex8("0x", resourceId));
        }
        if (removed > 0 && logger != null) {
            logger.logMessage("Removed-attribute " + (removed > 1 ? "(" + removed + "): " : ": ") + nameForLogging);
        }
    }

    @Deprecated
    public static int removeApplicationAttribute(AndroidManifestBlock manifestBlock, int resourceId) {
        if (resourceId == 0) {
            return 0;
        }
        ResXmlElement applicationElement = manifestBlock.getApplicationElement();
        if (applicationElement == null) {
            return 0;
        }
        return applicationElement.removeAttributesWithId(resourceId);
    }

    public static String getNamedValue(ResXmlElement element) {
        ResXmlAttribute attribute = CollectionUtil.getFirst(element.getAttributes(AndroidManifestHelper::isNameResourceId));
        if (attribute == null) {
            return "<not name attribute>";
        }
        return attribute.decodeValue();
    }

    static boolean isNameResourceId(ResXmlAttribute attribute) {
        int resourceId = attribute.getNameResourceID();
        return resourceId == 0x1010003;
    }
}

