/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apk.xmlencoder.EncodeException;
import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.cloner.Cloner;
import com.reandroid.apkeditor.compile.Builder;
import com.reandroid.apkeditor.decompile.Decompiler;
import com.reandroid.apkeditor.info.Info;
import com.reandroid.apkeditor.merge.Merger;
import com.reandroid.apkeditor.protect.Protector;
import com.reandroid.apkeditor.refactor.Refactor;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.coder.xml.XmlEncodeException;
import com.reandroid.commons.command.ARGException;
import java.io.IOException;

public class Main {
    public static void main(String[] args) {
        int result = Main.execute(args);
        System.exit(result);
    }

    public static int execute(String[] args) {
        if (Util.isHelp(args = Util.trimNull(args)) || args == null) {
            System.err.println(Main.getHelp());
            return 2;
        }
        if (Util.isVersion(args)) {
            System.err.println(Main.getVersion());
            return 2;
        }
        String command = Main.getCommand(args);
        args = Util.trimNull(args);
        int result = 1;
        try {
            Main.execute(command, args);
            result = 0;
        }
        catch (ARGException ex1) {
            System.err.flush();
            System.err.println(ex1.getMessage());
        }
        catch (EncodeException | XmlEncodeException ex) {
            System.err.flush();
            System.err.println("\nERROR:\n" + ex.getMessage());
        }
        catch (IOException ex2) {
            System.err.flush();
            System.err.println("\nERROR:");
            ex2.printStackTrace(System.err);
        }
        return result;
    }

    private static void execute(String command, String[] args) throws ARGException, IOException {
        if (Decompiler.isCommand(command)) {
            Decompiler.execute(args);
            return;
        }
        if (Builder.isCommand(command)) {
            Builder.execute(args);
            return;
        }
        if (Merger.isCommand(command)) {
            Merger.execute(args);
            return;
        }
        if (Refactor.isCommand(command)) {
            Refactor.execute(args);
            return;
        }
        if (Protector.isCommand(command)) {
            Protector.execute(args);
            return;
        }
        if (Cloner.isCommand(command)) {
            Cloner.execute(args);
            return;
        }
        if (Info.isCommand(command)) {
            Info.execute(args);
            return;
        }
        throw new ARGException("Unknown command: " + command);
    }

    private static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append(Main.getWelcome());
        builder.append("\nUsage: \n");
        builder.append(" java -jar ").append(APKEditor.getJarName());
        builder.append(" <command> <args>");
        builder.append("\n commands: \n");
        String[][] table = new String[][]{{"  1)  d | decode", "Decodes android resources binary to readable json/xml"}, {"  2)  b | build", "Builds android binary from json/xml"}, {"  3)  m | merge", "Merges split apk files from directory or compressed apk files like XAPK, APKM, APKS ..."}, {"  4)  x | refactor", "Refactors obfuscated resource names"}, {"  5)  p | protect", "Protects/Obfuscates apk resource"}, {"  6)  info", "Prints information of apk"}};
        StringHelper.printTwoColumns(builder, "  ", "  -  ", 75, table);
        builder.append("\n\n other options: \n");
        table = new String[][]{{" -h | -help | --help", "prints this help and exit"}, {"-version | --version", "prints version information of this tool and exit"}};
        StringHelper.printTwoColumns(builder, "  ", "   -   ", 75, table);
        builder.append("\n\n run with <command> -h to get detailed help about each command\n");
        return builder.toString();
    }

    private static String getVersion() {
        return APKEditor.getName() + " version " + APKEditor.getVersion() + ", " + BuildInfo.getName() + " version " + BuildInfo.getVersion();
    }

    private static String getWelcome() {
        return APKEditor.getName() + " - " + APKEditor.getVersion() + "\nUsing: " + APKEditor.getARSCLibInfo() + "\n" + APKEditor.getRepo() + "\n" + APKEditor.getDescription();
    }

    private static String getCommand(String[] args) {
        String cmd = args[0];
        args[0] = null;
        return cmd;
    }
}

