/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apkeditor.Options;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.coder.xml.XmlCoderLogger;
import com.reandroid.commons.utils.log.Logger;
import java.io.IOException;
import java.util.regex.Pattern;

public class BaseCommand<T extends Options>
implements APKLogger,
XmlCoderLogger {
    private final T options;
    private String mLogTag;
    private boolean mEnableLog;

    public BaseCommand(T options, String logTag) {
        this.options = options;
        this.mLogTag = logTag;
        this.mEnableLog = true;
    }

    public void run() throws IOException {
    }

    protected T getOptions() {
        return this.options;
    }

    protected void setLogTag(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.mLogTag = tag;
    }

    public void setEnableLog(boolean enableLog) {
        this.mEnableLog = enableLog;
    }

    @Override
    public void logMessage(String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.i(this.mLogTag + msg);
    }

    @Override
    public void logError(String msg, Throwable tr) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.e(this.mLogTag + msg, tr);
    }

    @Override
    public void logVerbose(String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.sameLine(this.mLogTag + msg);
    }

    @Override
    public void logMessage(String tag, String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.sameLine(this.mLogTag + msg);
    }

    @Override
    public void logVerbose(String tag, String msg) {
        if (!this.mEnableLog) {
            return;
        }
        Logger.sameLine(this.mLogTag + msg);
    }

    public void logWarn(String msg) {
        Logger.e(this.mLogTag + msg);
    }

    protected static void clearMeta(ApkModule module) {
        BaseCommand.removeSignature(module);
        module.setApkSignatureBlock(null);
    }

    protected static void removeSignature(ApkModule module) {
        ZipEntryMap archive = module.getZipEntryMap();
        archive.removeAll(Pattern.compile("^META-INF/.+\\.(([MS]F)|(RSA))"));
        archive.remove("stamp-cert-sha256");
    }
}

