/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor;

import com.reandroid.arsc.BuildInfo;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class APKEditor {
    private static Properties sProperties;
    public static final String PATH_properties = "/apkeditor.properties";

    public static String getARSCLibInfo() {
        return BuildInfo.getName() + "-" + BuildInfo.getVersion();
    }

    public static String getDescription() {
        return APKEditor.getProperties().getProperty("app.description", "---");
    }

    public static String getRepo() {
        return APKEditor.getProperties().getProperty("app.repo", "https://github.com/REAndroid");
    }

    public static String getName() {
        return APKEditor.getProperties().getProperty("app.name", "---");
    }

    public static String getVersion() {
        return APKEditor.getProperties().getProperty("app.version", "---");
    }

    private static Properties getProperties() {
        if (sProperties != null) {
            return sProperties;
        }
        sProperties = new Properties();
        try {
            sProperties.load(APKEditor.class.getResourceAsStream(PATH_properties));
        }
        catch (IOException ex) {
            sProperties.put("app.description", ex.getMessage());
        }
        return sProperties;
    }

    public static String getJarName() {
        File file = new File(APKEditor.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (file.isFile()) {
            return file.getName();
        }
        return APKEditor.getName() + ".jar";
    }
}

