/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.FrameworkApk;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.FilePathEncoder;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.ReferenceString;
import com.reandroid.arsc.coder.xml.XmlCoder;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLTableBlockEncoder {
    private APKLogger apkLogger;
    private final TableBlock tableBlock;
    private final Set<File> parsedFiles = new HashSet<File>();
    private final ApkModule apkModule;
    private Integer mMainPackageId;

    public XMLTableBlockEncoder(ApkModule apkModule, TableBlock tableBlock) {
        this.apkModule = apkModule;
        this.tableBlock = tableBlock;
        if (!apkModule.hasTableBlock()) {
            BlockInputSource<TableBlock> inputSource = new BlockInputSource<TableBlock>("resources.arsc", tableBlock);
            inputSource.setMethod(0);
            inputSource.setSort(1);
            this.apkModule.setTableBlock(this.tableBlock);
            apkModule.setLoadDefaultFramework(true);
        }
        this.apkLogger = apkModule.getApkLogger();
    }

    public XMLTableBlockEncoder() {
        this(new ApkModule("encoded", new ZipEntryMap()), new TableBlock());
    }

    public Integer getMainPackageId() {
        return this.mMainPackageId;
    }

    public TableBlock getTableBlock() {
        return this.tableBlock;
    }

    public ApkModule getApkModule() {
        return this.apkModule;
    }

    public void scanMainDirectory(File mainDirectory) throws IOException {
        File resourcesDirectory = new File(mainDirectory, "resources");
        this.scanResourcesDirectory(resourcesDirectory);
    }

    public void scanResourcesDirectory(File resourcesDirectory) throws IOException {
        try {
            this.scanResourceFiles(resourcesDirectory);
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
    }

    private void scanResourceFiles(File resourcesDirectory) throws IOException, XmlPullParserException {
        List<File> pubXmlFileList = ApkUtil.listPublicXmlFiles(resourcesDirectory);
        if (pubXmlFileList.size() == 0) {
            throw new IOException("No .*/values/public.xml  file found in '" + resourcesDirectory + "'");
        }
        this.loadPublicXmlFiles(pubXmlFileList);
        this.excludeIds(pubXmlFileList);
        this.initializeFrameworkFromManifest(pubXmlFileList);
        this.encodeAttrs(pubXmlFileList);
        this.encodeValues(pubXmlFileList);
        this.tableBlock.refresh();
    }

    private void loadPublicXmlFiles(List<File> pubXmlFileList) throws IOException {
        for (File pubXmlFile : pubXmlFileList) {
            this.loadPublicXmlFile(pubXmlFile);
        }
    }

    private void loadPublicXmlFile(File pubXmlFile) throws IOException {
        try {
            XmlPullParser parser = XMLFactory.newPullParser(pubXmlFile);
            PackageBlock packageBlock = this.tableBlock.parsePublicXml(parser);
            packageBlock.setTag(pubXmlFile);
            this.loadPackageJson(packageBlock, pubXmlFile);
            IOUtil.close(parser);
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
    }

    private void loadPackageJson(PackageBlock packageBlock, File publicXml) throws IOException {
        File json = this.toPackageJson(publicXml);
        if (json == null) {
            return;
        }
        packageBlock.fromJson(new JSONObject(json));
    }

    private File toPackageJson(File publicXml) {
        File dir = publicXml.getParentFile();
        if (dir == null || !"values".equals(dir.getName())) {
            return null;
        }
        if ((dir = dir.getParentFile()) == null) {
            return null;
        }
        if ((dir = dir.getParentFile()) == null) {
            return null;
        }
        File json = new File(dir, "package.json");
        if (!json.isFile()) {
            return null;
        }
        return json;
    }

    private void initializeFrameworkFromManifest(List<File> pubXmlFileList) throws IOException {
        for (File pubXmlFile : pubXmlFileList) {
            File manifestFile = this.toAndroidManifest(pubXmlFile);
            if (!manifestFile.isFile()) continue;
            this.initializeFrameworkFromManifest(manifestFile);
            return;
        }
    }

    private void encodeValues(List<File> pubXmlFileList) throws IOException, XmlPullParserException {
        this.logMessage("Encoding values ...");
        FilePathEncoder filePathEncoder = new FilePathEncoder(this.getApkModule());
        TableBlock tableBlock = this.getTableBlock();
        for (File pubXmlFile : pubXmlFileList) {
            this.addParsedFiles(pubXmlFile);
            PackageBlock packageBlock = tableBlock.getPackageBlockByTag(pubXmlFile);
            tableBlock.setCurrentPackage(packageBlock);
            File resDir = this.toResDirectory(pubXmlFile);
            this.encodeResDir(resDir);
            filePathEncoder.setApkLogger(this.getApkLogger());
            filePathEncoder.encodePackageResDir(packageBlock, resDir);
            packageBlock.sortTypes();
            packageBlock.refresh();
        }
    }

    private void encodeAttrs(List<File> pubXmlFileList) throws IOException, XmlPullParserException {
        this.logMessage("Encoding attrs ...");
        TableBlock tableBlock = this.getTableBlock();
        for (File pubXmlFile : pubXmlFileList) {
            this.addParsedFiles(pubXmlFile);
            PackageBlock packageBlock = tableBlock.getPackageBlockByTag(pubXmlFile);
            tableBlock.setCurrentPackage(packageBlock);
            List<File> attrFiles = this.listAttrs(pubXmlFile);
            if (attrFiles.size() == 0) continue;
            for (File file : attrFiles) {
                this.logVerbose("Encoding: " + IOUtil.shortPath(file, 4));
                XmlCoder xmlCoder = XmlCoder.getInstance();
                xmlCoder.VALUES_XML.encode(file, packageBlock);
                this.addParsedFiles(file);
            }
            packageBlock.sortTypes();
        }
    }

    private void excludeIds(List<File> pubXmlFileList) {
        for (File pubXmlFile : pubXmlFileList) {
            this.addParsedFiles(pubXmlFile);
            File valuesDir = pubXmlFile.getParentFile();
            File file = new File(valuesDir, "ids.xml");
            if (!file.isFile()) continue;
            this.addParsedFiles(file);
        }
    }

    private void initializeFrameworkFromManifest(File manifestFile) throws IOException {
        XMLDocument xmlDocument;
        if ("AndroidManifest.xml.bin".equals(manifestFile.getName())) {
            this.initializeFrameworkFromBinaryManifest();
            return;
        }
        try {
            xmlDocument = XMLDocument.load(manifestFile);
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
        TableBlock tableBlock = this.getTableBlock();
        FrameworkApk frameworkApk = this.getApkModule().initializeAndroidFramework(xmlDocument);
        if (frameworkApk != null) {
            tableBlock.addFramework(frameworkApk.getTableBlock());
        }
        this.initializeMainPackageId(xmlDocument);
    }

    private void initializeFrameworkFromBinaryManifest() throws IOException {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasTableBlock() || !apkModule.hasAndroidManifestBlock()) {
            return;
        }
        this.logMessage("Initialize framework from binary manifest ...");
        FrameworkApk frameworkApk = apkModule.initializeAndroidFramework(apkModule.getAndroidFrameworkVersion());
        this.getTableBlock().addFramework(frameworkApk.getTableBlock());
    }

    private void initializeMainPackageId(XMLDocument xmlDocument) {
        XMLElement manifestRoot = xmlDocument.getDocumentElement();
        if (manifestRoot == null) {
            return;
        }
        XMLElement application = manifestRoot.getElement("application");
        if (application == null) {
            return;
        }
        String iconReference = application.getAttributeValue("icon");
        if (iconReference == null) {
            return;
        }
        this.logMessage("Set main package id from manifest: " + iconReference);
        ReferenceString ref = ReferenceString.parseReference(iconReference);
        if (ref == null) {
            this.logMessage("Something wrong on : icon");
            return;
        }
        TableBlock tableBlock = this.getTableBlock();
        int resourceId = tableBlock.resolveResourceId(ref.packageName, ref.type, ref.name);
        if (resourceId == 0) {
            this.logMessage("WARN: failed to resolve: " + ref);
            return;
        }
        int packageId = resourceId >> 24 & 0xFF;
        this.mMainPackageId = packageId;
        this.logMessage("Main package id initialized: id = " + HexUtil.toHex2((byte)packageId) + ", from: " + ref);
    }

    private void encodeResDir(File resDir) throws IOException, XmlPullParserException {
        List<File> valuesDirList = ApkUtil.listValuesDirectory(resDir);
        for (File valuesDir : valuesDirList) {
            this.encodeValuesDir(valuesDir);
        }
    }

    private void encodeValuesDir(File valuesDir) throws IOException, XmlPullParserException {
        List<File> xmlFiles = ApkUtil.listFiles(valuesDir, ".xml");
        EncodeUtil.sortValuesXml(xmlFiles);
        for (File file : xmlFiles) {
            if (this.isAlreadyParsed(file)) continue;
            this.addParsedFiles(file);
            this.logVerbose("Encoding: " + IOUtil.shortPath(file, 4));
            XmlCoder xmlCoder = XmlCoder.getInstance();
            xmlCoder.VALUES_XML.encode(file, this.getTableBlock().getCurrentPackage());
        }
    }

    private File toAndroidManifest(File pubXmlFile) {
        File resDirectory = this.toResDirectory(pubXmlFile);
        File packageDirectory = resDirectory.getParentFile();
        File resourcesDir = packageDirectory.getParentFile();
        File root = resourcesDir.getParentFile();
        File file = new File(root, "AndroidManifest.xml.bin");
        if (!file.isFile()) {
            file = new File(root, "AndroidManifest.xml");
        }
        return file;
    }

    private File toResDirectory(File pubXmlFile) {
        return pubXmlFile.getParentFile().getParentFile();
    }

    private List<File> listAttrs(File pubXmlFile) {
        return this.listValuesXml(pubXmlFile, "attr");
    }

    private List<File> listValuesXml(File pubXmlFile, String type) {
        ArrayList<File> results = new ArrayList<File>();
        File resDir = this.toResDirectory(pubXmlFile);
        List<File> valuesDirList = ApkUtil.listValuesDirectory(resDir);
        for (File valuesDir : valuesDirList) {
            results.addAll(this.findValuesXml(valuesDir, type));
        }
        return results;
    }

    private List<File> findValuesXml(File valuesDir, String type) {
        ArrayList<File> results = new ArrayList<File>();
        File[] xmlFiles = valuesDir.listFiles();
        if (xmlFiles == null) {
            return results;
        }
        for (File file : xmlFiles) {
            String name;
            if (!file.isFile() || !(name = file.getName()).endsWith(".xml") || !(name = EncodeUtil.sanitizeType(name)).equals(type)) continue;
            results.add(file);
        }
        return results;
    }

    private boolean isAlreadyParsed(File file) {
        return this.parsedFiles.contains(file);
    }

    private void addParsedFiles(File file) {
        this.parsedFiles.add(file);
    }

    public APKLogger getApkLogger() {
        return this.apkLogger;
    }

    public void setApkLogger(APKLogger logger) {
        this.apkLogger = logger;
        if (logger != null && this.apkModule.getApkLogger() == null) {
            this.apkModule.setAPKLogger(logger);
        }
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.getApkLogger();
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }

    private void logVerbose(String msg) {
        APKLogger apkLogger = this.getApkLogger();
        if (apkLogger != null) {
            apkLogger.logVerbose(msg);
        }
    }
}

