/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.APKLogger;
import com.reandroid.archive.ByteInputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.source.XMLParserSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLEncodeSource
extends ByteInputSource {
    private final PackageBlock packageBlock;
    private final XMLParserSource parserSource;
    private APKLogger mLogger;
    private byte[] array;
    private static final byte[] DISPOSED = new byte[0];

    public XMLEncodeSource(PackageBlock packageBlock, XMLParserSource parserSource) {
        super(DISPOSED, parserSource.getPath());
        this.packageBlock = packageBlock;
        this.parserSource = parserSource;
    }

    @Override
    public long getLength() throws IOException {
        return this.getArray().length;
    }

    @Override
    public long getCrc() throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] bytes = this.getArray();
        crc32.update(bytes, 0, bytes.length);
        return crc32.getValue();
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        byte[] bytes = this.getArray();
        if (bytes == DISPOSED) {
            throw new IOException("Disposed source: " + this.getAlias());
        }
        outputStream.write(bytes, 0, bytes.length);
        return bytes.length;
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.getArray();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public void disposeInputSource() {
        this.array = DISPOSED;
    }

    private byte[] getArray() throws IOException {
        if (this.array != null) {
            return this.array;
        }
        try {
            this.array = this.encode().getBytes();
        }
        catch (XmlPullParserException ex) {
            throw new IOException(ex);
        }
        return this.array;
    }

    private ResXmlDocument encode() throws XmlPullParserException, IOException {
        XMLParserSource parserSource = this.parserSource;
        this.logVerbose("Encoding: " + parserSource.getPath());
        XmlPullParser parser = parserSource.getParser();
        ResXmlDocument resXmlDocument = new ResXmlDocument();
        resXmlDocument.setPackageBlock(this.packageBlock);
        resXmlDocument.parse(parser);
        IOUtil.close(parser);
        return resXmlDocument;
    }

    public void setApkLogger(APKLogger logger) {
        this.mLogger = logger;
    }

    private void logVerbose(String msg) {
        APKLogger logger = this.mLogger;
        if (logger != null) {
            logger.logVerbose(msg);
        }
    }
}

