/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UncompressedFiles
implements JSONConvert<JSONObject> {
    private final Set<String> mPathList = new HashSet<String>();
    private final Set<String> mExtensionList = new HashSet<String>();
    private String mResRawDir;
    public static final String JSON_FILE = "uncompressed-files.json";
    public static final String NAME_paths = "paths";
    public static final String NAME_extensions = "extensions";
    public static String[] COMMON_EXTENSIONS = new String[]{".png", ".jpg", ".mp3", ".mp4", ".wav", ".webp"};

    public void setResRawDir(String resRawDir) {
        this.mResRawDir = resRawDir;
    }

    public void apply(ZipEntryMap archive) {
        for (InputSource inputSource : archive.toArray()) {
            this.apply(inputSource);
        }
    }

    public void apply(InputSource inputSource) {
        inputSource.setUncompressed(this.isUncompressed(inputSource.getAlias()) || this.isUncompressed(inputSource.getName()));
    }

    public boolean isUncompressed(String path) {
        if (path == null) {
            return false;
        }
        if (this.containsPath(path) || this.containsExtension(path) || this.isResRawDir(path)) {
            return true;
        }
        String extension = UncompressedFiles.getExtension(path);
        return this.containsExtension(extension);
    }

    private boolean isResRawDir(String path) {
        String dir = this.mResRawDir;
        if (dir == null || dir.length() == 0) {
            return false;
        }
        return path.startsWith(dir);
    }

    public boolean containsExtension(String extension) {
        if (extension == null) {
            return false;
        }
        if (this.mExtensionList.contains(extension)) {
            return true;
        }
        if (!extension.startsWith(".")) {
            return this.mExtensionList.contains("." + extension);
        }
        return this.mExtensionList.contains(extension.substring(1));
    }

    public boolean containsPath(String path) {
        if ((path = UncompressedFiles.sanitizePath(path)) == null) {
            return false;
        }
        return this.mPathList.contains(path);
    }

    public void addPath(ZipEntryMap zipArchive) {
        for (InputSource inputSource : zipArchive.toArray()) {
            this.addPath(inputSource);
        }
    }

    public void addPath(InputSource inputSource) {
        if (!inputSource.isUncompressed()) {
            return;
        }
        this.addPath(inputSource.getAlias());
    }

    public void addPath(String path) {
        if ((path = UncompressedFiles.sanitizePath(path)) == null) {
            return;
        }
        this.mPathList.add(path);
    }

    public void removePath(String path) {
        if ((path = UncompressedFiles.sanitizePath(path)) == null) {
            return;
        }
        this.mPathList.remove(path);
    }

    public void replacePath(String path, String rep) {
        path = UncompressedFiles.sanitizePath(path);
        rep = UncompressedFiles.sanitizePath(rep);
        if (path == null || rep == null) {
            return;
        }
        if (!this.mPathList.contains(path)) {
            return;
        }
        this.mPathList.remove(path);
        this.mPathList.add(rep);
    }

    public void addCommonExtensions() {
        for (String ext : COMMON_EXTENSIONS) {
            this.addExtension(ext);
        }
    }

    public void addExtension(String extension) {
        if (extension == null || extension.length() == 0) {
            return;
        }
        this.mExtensionList.add(extension);
    }

    public void clearPaths() {
        this.mPathList.clear();
    }

    public void clearExtensions() {
        this.mExtensionList.clear();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_extensions, new JSONArray((Collection<?>)this.mExtensionList));
        jsonObject.put(NAME_paths, new JSONArray((Collection<?>)this.mPathList));
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        JSONArray paths;
        this.clearExtensions();
        this.clearPaths();
        if (json == null) {
            return;
        }
        JSONArray extensions = json.optJSONArray(NAME_extensions);
        if (extensions != null) {
            int length = extensions.length();
            for (int i = 0; i < length; ++i) {
                this.addExtension(extensions.getString(i));
            }
        }
        if ((paths = json.optJSONArray(NAME_paths)) != null) {
            int length = paths.length();
            for (int i = 0; i < length; ++i) {
                this.addPath(paths.getString(i));
            }
        }
    }

    public void merge(UncompressedFiles uf) {
        if (uf == null || uf == this) {
            return;
        }
        for (String path : uf.mPathList) {
            this.addPath(path);
        }
        for (String ext : uf.mExtensionList) {
            this.addExtension(ext);
        }
    }

    @Override
    public void fromJson(File jsonFile) throws IOException {
        if (!jsonFile.isFile()) {
            return;
        }
        JSONObject jsonObject = new JSONObject(new FileInputStream(jsonFile));
        this.fromJson(jsonObject);
    }

    private static String sanitizePath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        path = path.replace(File.separatorChar, '/').trim();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() == 0) {
            return null;
        }
        return path;
    }

    private static String getExtension(String path) {
        if ((path = UncompressedFiles.sanitizePath(path)) == null) {
            return null;
        }
        int i = path.lastIndexOf(47);
        if (i > 0) {
            path = path.substring(++i);
        }
        if ((i = path.lastIndexOf(46)) > 0) {
            return path.substring(i);
        }
        return null;
    }
}

